#include "mbed.h"
#include "TB6612.h"

#define MOTOR_MAX_VALUE 100

#define KP 1
#define KI 0
#define KD 20

BusIn sensor(p15,p16,p17);
TB6612 MOTOR_A(p21,p19,p20);
TB6612 MOTOR_B(p22,p29,p30);
DigitalIn SW1(p25);
Ticker tick;

int motor_cnt_val = 0;

void cycle()
{
	float sensor_val = 0;
	float p_val,d_val,pid_val;
	static float i_val,prev_sensor_val = 0;

	switch(sensor)
	{
	case 0x01:    sensor_val = 100.0;   break;
	case 0x03:    sensor_val = 50.0;  	break;
	case 0x02:    sensor_val = 0.0;  	break;
	case 0x06:    sensor_val = -50.0;   break;
	case 0x04:    sensor_val = -100.0;  break;
	default:      sensor_val = prev_sensor_val; break;
	}

	p_val = sensor_val;
	i_val += p_val;
	d_val = sensor_val - prev_sensor_val;
	prev_sensor_val = sensor_val;

	pid_val = (p_val * (KP) ) + (i_val*(KI)) + (d_val*(KD));

	motor_cnt_val = (int)(pid_val);
}

int main() {
	SW1.mode(PullUp);

	tick.attach(cycle,0.01);

	while(SW1==1);

	wait(1);

	while(1) {
		if( motor_cnt_val < 0 ) {
			MOTOR_A = MOTOR_MAX_VALUE
					+ motor_cnt_val;
		} else {
			MOTOR_A = MOTOR_MAX_VALUE;
		}
		if( motor_cnt_val > 0 ) {
			MOTOR_B = MOTOR_MAX_VALUE
				   - motor_cnt_val;
		} else {
			MOTOR_B = MOTOR_MAX_VALUE;
		}
	}
}
