/**
 *  Matrix16x16 LEDPanel library
 *
 *  @author  Junichi Katsu
 *  @version 1.0
 *  @date    15-April-2015
 *
 */
 
#ifndef MBED_LEDPANEL_H
#define MBED_LEDPANEL_H
 
#include "mbed.h"
#include "LedPanel_GFX.h"

#define HT16K33_BLINK_CMD 0x80
#define HT16K33_BLINK_DISPLAYON 0x01
#define HT16K33_BLINK_OFF 0
#define HT16K33_BLINK_2HZ  1
#define HT16K33_BLINK_1HZ  2
#define HT16K33_BLINK_HALFHZ  3
#define HT16K33_CMD_BRIGHTNESS 0x0E

/** LedMatrix8x8Driver class
 *  @endcode
 */
 
class LedPanel : public LedPanel_GFX
{
public:
    /** Create a LedPanel instance
     *
     * @param I2C 
     */
    LedPanel(I2C *i2c);
	void begin(uint8_t _addr0,uint8_t _addr1);
	void setBrightness(uint8_t b);
	void blinkRate(uint8_t b);
	void writeDisplay(void);
	void clear(void);
	
	uint16_t displaybuffer[16]; 

	void init(uint8_t a);
	
  	virtual void drawPixel(int16_t x, int16_t y, uint16_t color);
    
private:
 	I2C *_i2c;
  	uint8_t i2c_addr[2];
};
 
#endif // MBED_LEDPANEL_H