#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "LedPanel.h"
#include "LedPanel_GFX.h"

EthernetInterface eth;
NTPClient ntp;
I2C i2c(p9, p10);
PwmOut spkr(p21);

LedPanel matrix(&i2c);

void Alarm()
{
    spkr.period(1.0/2000.0);
    spkr=0.5;
    wait(0.5);
    spkr=0.0;   
}

char *Number2ShiftJis(char num)
{
    short code = num + 0x824F;
    char ShiftJisCode[3];
    
    code = ntohs(code);
    memcpy( ShiftJisCode , &code , 2 );
    ShiftJisCode[2] = '\0';
    return(ShiftJisCode);
}

int main() 
{
    matrix.begin(0x70,0x71);
    matrix.setBrightness(1);
    
    matrix.writeDisplay();

    eth.init(); //Use DHCP

    eth.connect();
   
    printf("Trying to update time...\r\n");
    if (ntp.setTime("ntp.nict.jp") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL) + 32400;
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
      return(-1);
    } 
   
    eth.disconnect();
    
    int old_hour = 0;
    int old_min = 0;

    while(1) {
        
        time_t ctTime;
        ctTime = time(NULL) + 32400;

        struct tm * strtim;
        strtim = localtime( &ctTime );
        
        if( strtim->tm_min != old_min )
        {
            old_min = strtim->tm_min;
            matrix.setCursor(0,0);
            matrix.printf("%s",Number2ShiftJis(strtim->tm_hour/10));
            matrix.printf("%s",Number2ShiftJis(strtim->tm_hour%10));
            matrix.printf("%s",Number2ShiftJis(strtim->tm_min/10));
            matrix.printf("%s",Number2ShiftJis(strtim->tm_min%10));
            matrix.writeDisplay();
        }
        if( strtim->tm_hour != old_hour )
        {
            old_hour = strtim->tm_hour;
            Alarm();
        }
    }
}

