#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "LedPanel.h"
#include "LedPanel_GFX.h"
#include "LM61CIZ.h"

LM61CIZ Temperature(p20);

EthernetInterface eth;
NTPClient ntp;
I2C i2c(p9, p10);
PwmOut spkr(p21);
DigitalIn SW1(p25);
DigitalIn SW2(p26);

LedPanel matrix(&i2c);

void Alarm()
{
    spkr.period(1.0/2000.0);
    spkr=0.5;
    wait(0.5);
    spkr=0.0;   
}

char *Number2ShiftJis(char num)
{
    short code = num + 0x824F;
    char ShiftJisCode[3];
    
    code = ntohs(code);
    memcpy( ShiftJisCode , &code , 2 );
    ShiftJisCode[2] = '\0';
    return(ShiftJisCode);
}

void DspTime( struct tm *strtim )
{
    matrix.setCursor(0,0);
    matrix.printf("%s",Number2ShiftJis(strtim->tm_hour/10));
    matrix.printf("%s",Number2ShiftJis(strtim->tm_hour%10));
    matrix.printf("%s",Number2ShiftJis(strtim->tm_min/10));
    matrix.printf("%s",Number2ShiftJis(strtim->tm_min%10));
    matrix.writeDisplay();
}

int main() 
{
	SW1.mode(PullUp);
	SW2.mode(PullUp);
	
    matrix.begin(0x70,0x71);
    matrix.setBrightness(1);
    
    matrix.writeDisplay();
    
    eth.init();
    eth.connect();
   
    printf("Trying to update time...\r\n");
    if (ntp.setTime("ntp.nict.jp") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL) + 32400;
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
      return(-1);
    } 
   
    eth.disconnect();
    
    int old_hour = 0;
    int old_min = 0;
	time_t AlarmTime = 0;
	bool AlarmSettingFlag = false;
	bool AlarmFlag = false;

    while(1) {
        
        time_t ctTime;
        ctTime = time(NULL) + 32400;

        struct tm * strtim;
        
		if( AlarmSettingFlag == false )
		{
	        strtim = localtime( &ctTime );
	    }
	    else
	    {
			if( SW2 == 0 )
			{
				AlarmTime += 600;
				wait(0.5);
			}
			strtim = localtime( &AlarmTime );
		}
        if( ( SW2 == 0 )&&(AlarmSettingFlag == false) )
        {
            matrix.setCursor(0,0);
            int tmp = Temperature.getTemperature() * 10.0;
            
            if(tmp >= 0)
            {
                matrix.printf("%s",Number2ShiftJis(tmp/100));
                matrix.printf("%s",Number2ShiftJis((tmp%100)/10));
                matrix.printf("%c%c",0x81,0x44);
                matrix.printf("%s",Number2ShiftJis(tmp%10));
            }
            else
		    {
			    matrix.printf("%c%c",0x81,0x40);
			    matrix.printf("%c%c",0x81,0x7C);
			    matrix.printf("%s",Number2ShiftJis(-tmp/100));
			    matrix.printf("%s",Number2ShiftJis((-tmp%100)/10));
		    }
		    
		    matrix.writeDisplay();
		    
		    old_min = 61;
		    wait(3.0);
		}
		else
		{
	        if( (strtim->tm_min != old_min)
	          ||(strtim->tm_hour != old_hour) )
	        {
	            old_min = strtim->tm_min;
	            old_hour = strtim->tm_hour;
	            DspTime(strtim);
			}
		}
		if( SW1 == 0 )
		{
			AlarmSettingFlag = !AlarmSettingFlag;
			wait(0.5);
		}

		if((ctTime % 86400) == (AlarmTime % 86400))
		{
			Alarm();
		}
    }
}

