/**
 *  Matrix16x16 LEDPanel library
 *
 *  @author  Junichi Katsu
 *  @version 1.0
 *  @date    02-April-2015
 *
 */
 
#include "mbed.h"
#include "LedPanel.h"
#include "LedPanel_GFX.h"

LedPanel::LedPanel(I2C *i2c): _i2c(i2c), LedPanel_GFX(16, 16)
{
	
}

void LedPanel::setBrightness(uint8_t b)
{
	if (b > 15) b = 15;
	
	uint8_t c = 0xE0 | b;
	char foo[1];
	
	foo[0] = c;
	
	_i2c->write(i2c_addr[0], foo, 1); 
	_i2c->write(i2c_addr[1], foo, 1); 
}

void LedPanel::blinkRate(uint8_t b)
{
	if (b > 3) b = 0;

	uint8_t c = HT16K33_BLINK_CMD | HT16K33_BLINK_DISPLAYON | (b << 1);

	char foo[1];
	foo[0] = c;

	_i2c->write(i2c_addr[0], foo, 1);
	_i2c->write(i2c_addr[1], foo, 1);
}

void LedPanel::begin(uint8_t _addr0,uint8_t _addr1)
{
	i2c_addr[0] = _addr0 << 1;
	i2c_addr[1] = _addr1 << 1;

	char foo[1];
	foo[0] = 0x21;

	_i2c->write(i2c_addr[0], foo, 1);
	_i2c->write(i2c_addr[1], foo, 1);

	blinkRate(HT16K33_BLINK_OFF);

	setBrightness(15);
}

void LedPanel::writeDisplay(void)
{
	char foo[2][17];
	foo[0][0] = 0x00;
	foo[1][0] = 0x00;

	int j = 0;
	for (uint8_t i=1; i<=16; i+=2)
	{
		for(uint8_t k=0; k < 2 ; k++)
		{
			int x = displaybuffer[j + k*8] & 0xFF;
			foo[k][i] = x;
			x = displaybuffer[j + k*8] >> 8;
			foo[k][i+1] = x;
		}
		j++;
	}
	_i2c->write(i2c_addr[0], foo[0], 17);
	_i2c->write(i2c_addr[1], foo[1], 17);
}

void LedPanel::clear(void)
{
	for (uint8_t i=0; i<16; i++)
	{
		displaybuffer[i] = 0;
	}
}

void LedPanel::drawPixel(int16_t x, int16_t y, uint16_t color)
{
	if ((y < 0) || (y >= 16)) return;
	if ((x < 0) || (x >= 16)) return;

	if (color)
	{
		displaybuffer[y] |= 1 << x;
	}
	else
	{
		displaybuffer[y] &= ~(1 << x);
	}
}

void LedPanel::Scroll(int16_t x, int16_t y)
{
	bool bit[16];
	for (uint8_t i=0; i<16; i++)
	{
		bit[i] = false;
		
		if( (displaybuffer[i] & 0x8000) != 0 )
		{
			bit[i] = true;
		}
		displaybuffer[i] <<= 1;
		
		if( bit[i] == true )
		{
			displaybuffer[i] |= 1;
		}
	}
}