/**
 *  Matrix8x8 LED library
 *
 *  @author  Junichi Katsu
 *  @version 1.0
 *  @date    15-April-2015
 *
 */
 
#ifndef MBED_LED_MATRIX8X8_DRIVER_H
#define MBED_LED_MATRIX8X8_DRIVER_H
 
#include "mbed.h"
#include "Adafruit_GFX.h"

/** LedMatrix8x8Driver class
 *  @endcode
 */
 
class LedMatrix8x8Driver : public Adafruit_GFX
{
public:
    /** Create a LedMatrix8x8Driver instance
     *
     * @param Matrix column
     * @param Matrix row
     */
    LedMatrix8x8Driver(BusOut* Col,BusOut* Row);
    
  	virtual void drawPixel(int16_t x, int16_t y, uint16_t color);
	void flip();
    
private:
 	BusOut* _Col;
	BusOut* _Row;
	Ticker flipper;
	uint8_t displaybuffer[8]; 
};
 
#endif // MBED_LED_MATRIX8X8_DRIVER_H