/**
 *  LM61CIZ Temperature sensor library
 *
 *  @author  Junichi Katsu
 *  @version 1.0
 *  @date    02-April-2015
 *
 */
 
#include "mbed.h"
#include "LedMatrix8x8Driver.h"
#include "Adafruit_GFX.h"

LedMatrix8x8Driver::LedMatrix8x8Driver(BusOut* Col,BusOut* Row) : Adafruit_GFX(8, 8)
{
    _Col = Col;
	_Row = Row;
	
	for(int i=0;i<8;i++)
	{
		displaybuffer[i] = 0;
	}
	
	flipper.attach(this,&LedMatrix8x8Driver::flip,0.002);
}

void LedMatrix8x8Driver::drawPixel(int16_t x, int16_t y, uint16_t color) {
	if ((y < 0) || (y >= 8)) return;
	if ((x < 0) || (x >= 8)) return;
	
	if (color) {
		displaybuffer[y] |= 1 << x;
	} else {
		displaybuffer[y] &= ~(1 << x);
	}
}

void LedMatrix8x8Driver::flip() {
    static int col = 0;

    _Row->write(0);
    _Col->write(displaybuffer[col]);
    _Row->write(1 << col);
    
    col++;
    col %= 8;
}