#include <mbed.h>

#include "ReceiverIR.h"

ReceiverIR ir_rx(p14);

int receive(RemoteIR::Format *format, uint8_t *buf, int bufsiz, int timeout = 100) {
    int cnt = 0;
    while (ir_rx.getState() != ReceiverIR::Received) {
        cnt++;
        if (timeout <cnt) {
            return -1;
        }
    }
    return ir_rx.getData(format, buf, bufsiz * 8);
}

int main(void) {
    while (1) {
        uint8_t buf[32];
        int bitlength1;
        RemoteIR::Format format;
        
        memset(buf, 0x00, sizeof(buf));

        bitlength1 = receive(&format, buf, sizeof(buf));
        if (bitlength1 < 0) {
            continue;
        }
        for(int i=0;i<bitlength1/8+((bitlength1 % 8) != 0) ? 1 : 0;i++)
        {
            printf("%02X",buf[i]);    
        }
        printf("\r\n");
    }
}
