/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#include "UsbEndpoint.h"
#include "UsbDevice.h"
#include "usb_mem.h"

//#define __DEBUG
//#define __DEBUG3
//#include "dbg/dbg.h"
#include "mydbg.h"

void UsbEndpoint::UsbEndpoint_iso(UsbDevice* pDevice, uint8_t ep, bool dir, UsbEndpointType type, uint16_t size, int addr)
{
  m_itdActive = 0;
  m_pEd = (volatile HCED*)usb_get_ed();
  DBG_ASSERT(m_pEd);
  memset((void*)m_pEd, 0, sizeof(HCED));
  
  m_pTdHead = NULL;
  m_pTdTail = NULL;
  
  volatile HCTD* itd = (volatile HCTD*)usb_get_itd((uint32_t)this);
  DBG_ASSERT(itd);
  memset((void*)itd, 0, sizeof(HCITD));
  DBG3("m_pEd =%p\n", m_pEd);
  DBG3("itd   =%p\n", itd);
  
  if(addr == -1)
    addr = pDevice->m_addr;
  
  //Setup Ed
  //printf("\r\n--Ep Setup--\r\n");
  m_pEd->Control =  addr | /* USB address */
      ((ep & 0x7F) << 7) | /* Endpoint address */
      ((dir?2:1) << 11)  | /* direction : Out = 1, 2 = In */
      (1 << 15)          | /* F Format */
      (size << 16);        /* MaxPkt Size */

  DBG3("m_pEd->Control=%08X\n", m_pEd->Control);

  m_dir = dir;
  m_setup = false;
  m_type = type;
  
  m_pEd->TailTd = m_pEd->HeadTd = (uint32_t)itd; //Empty TD list
  
  DBG("Before link\n");
  
  //printf("\r\n--Ep Reg--\r\n");
  //Append Ed to Ed list
  HCCA* hcca = (HCCA*)usb_get_hcca();
  for(int i = 0; i < 32; i++) {
    if (hcca->IntTable[i] == 0) {
      hcca->IntTable[i] = (uint32_t)m_pEd;
    } else {
      volatile HCED* nextEd = (volatile HCED*)hcca->IntTable[i];
      while(nextEd->Next && nextEd->Next != (uint32_t)m_pEd) {
        nextEd = (volatile HCED*)nextEd->Next;
      }
      nextEd->Next = (uint32_t)m_pEd;
    }
  }
}

// for isochronous 
UsbErr UsbEndpoint::transfer(uint16_t frame, int count, volatile uint8_t* buf, int len)
{
  DBG_ASSERT(count >= 1 && count <= 8);
  DBG_ASSERT(buf);
  DBG_ASSERT((len % count) == 0);
  HCITD *itd = (HCITD*)m_pEd->TailTd;
  DBG_ASSERT(itd); 
  HCITD *new_itd = (HCITD*)usb_get_itd((uint32_t)this);
  DBG_ASSERT(new_itd);
  if (itd == NULL) {
    return USBERR_ERROR;
  }
  DBG("itd=%p\n", itd);
  DBG2("new_itd=%p\n", new_itd);
  int di = 0; //DelayInterrupt
  itd->Control = 0xe0000000        | // CC ConditionCode NOT ACCESSED
                 ((count-1) << 24) | // FC FrameCount
                 TD_DELAY_INT(di)  | // DI DelayInterrupt
                 frame;              // SF StartingFrame
  itd->BufferPage0 = (uint32_t)buf;
  itd->BufferEnd = (uint32_t)buf+len-1;
  itd->Next = (uint32_t)new_itd; 
  uint16_t offset[8];
  for(int i = 0; i < 8; i++) {
      uint32_t addr = (uint32_t)buf + i*(len/count);
      offset[i] = addr & 0x0fff;
      if ((addr&0xfffff000) == (itd->BufferEnd&0xfffff000)) {
          offset[i] |= 0x1000;
      }
      offset[i] |= 0xe000;
  }
  itd->OffsetPSW10 = (offset[1]<<16) | offset[0];
  itd->OffsetPSW32 = (offset[3]<<16) | offset[2];
  itd->OffsetPSW54 = (offset[5]<<16) | offset[4];
  itd->OffsetPSW76 = (offset[7]<<16) | offset[6];
  m_itdActive++;
  DBG2("itd->Control    =%08X\n", itd->Control); 
  DBG2("itd->BufferPage0=%08X\n", itd->BufferPage0); 
  DBG2("itd->Next       =%08X\n", itd->Next); 
  DBG2("itd->BufferEnd  =%08X\n", itd->BufferEnd); 
  DBG2("itd->OffsetPSW10=%08X\n", itd->OffsetPSW10); 
  DBG2("itd->OffsetPSW32=%08X\n", itd->OffsetPSW32); 
  DBG2("itd->OffsetPSW54=%08X\n", itd->OffsetPSW54); 
  DBG2("itd->OffsetPSW76=%08X\n", itd->OffsetPSW76); 
  m_pEd->TailTd = (uint32_t)new_itd; // start!!!
  LPC_USB->HcControl |= OR_CONTROL_PLE; //Enable Periodic
  return USBERR_PROCESSING;
}
