#ifndef MSC_H
#define MSC_H
#include "UsbHostMgr.h"
#include "UsbEndpoint.h"
#include "UsbBaseClass.h"
#include "FATFileSystem.h"

#define  SCSI_CMD_REQUEST_SENSE      0x03
#define  SCSI_CMD_TEST_UNIT_READY    0x00
#define  SCSI_CMD_INQUIRY            0x12
#define  SCSI_CMD_READ_10            0x28
#define  SCSI_CMD_READ_CAPACITY      0x25
#define  SCSI_CMD_WRITE_10           0x2A

#pragma pack(push,1)
typedef struct stcbw {
    uint32_t dCBWSignature;
    uint32_t dCBWTag;
    uint32_t dCBWDataTraansferLength;
    uint8_t bmCBWFlags;
    uint8_t bCBWLUN;
    uint8_t bCBWCBLength;
    uint8_t CBWCB[16];
} CBW;

typedef struct stcsw {
    uint32_t dCSWSignature;
    uint32_t dCSWTag;
    uint32_t dCSWDataResidue;
    uint8_t  bCSWStatus;
} CSW;
#pragma pack(pop)

class msc : public FATFileSystem, public UsbBaseClass {
public:
    msc(const char* name = NULL, int drive = 0);
    virtual int disk_initialize();
    virtual int disk_write(const char *buffer, int block_number);
    virtual int disk_read(char *buffer, int block_number);    
    virtual int disk_status();
    virtual int disk_sync();
    virtual int disk_sectors();

    int setup(int timeout = 9000);
    void _test();
private:
    int ParseConfiguration();
    int BulkOnlyMassStorageReset();
    int GetMaxLUN();
    int ReadCapacity();
    int GetSenseInfo();
    int TestUnitReady();
    int Inquire();
    int MS_BulkRecv(uint32_t block_number, int num_blocks, uint8_t* user_buffer);
    int MS_BulkSend(uint32_t block_number, int num_blocks, uint8_t* user_buffer);
    int CommandTransport(const uint8_t* cdb, int size);
    int StatusTransport();
    int _bulkRecv(uint8_t* buf, int size);
    int _bulkSend(uint8_t* buf, int size);
    const char* m_name;
    int m_drive;
    uint32_t m_numBlocks;
    int m_BlockSize;
    int m_lun;
    int m_MaxLUN;
    int m_interface;
    uint32_t m_tag;
    CBW m_CBW;
    CSW m_CSW;
    UsbDevice* m_pDev;
    UsbEndpoint* m_pEpBulkIn;
    UsbEndpoint* m_pEpBulkOut;
};

#endif // MSC_H
