#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "rtos.h"

#define YELLOW 0xFFFF00
#define PURPLE 0x9900FF
#define ORANGE 0xFF9900
#define CYAN 0x66FFFF

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
DigitalOut myled(LED1);
DigitalIn pb1(p8);
SDFileSystem sd(p5, p6, p7, p9, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogOut DACout(p18);

FILE *wave_file;
wave_player waver(&DACout);

//speed or rate of change in ball movement
float dx;
float dy;
float paddle_dx;

//ball position
float ball_x;
float ball_y;

//paddle position
double paddle_x1;
double paddle_y1;
double paddle_x2;
double paddle_y2;

bool loss;
bool collision;
bool movement = false;
int life;
int radius = 5;


class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}
 
Nav_Switch myNav( p10, p11, p12, p13, p14); //pin order on Sparkfun breakout


struct Bricks
{
    int x1[6];
    int y1[6];
    int x2[6];
    int y2[6];
    int color[6];
    bool brickLife[6];
}; Bricks bricks;

void initBall(){
    ball_x = 64;
    ball_y = 110;
    uLCD.filled_circle(ball_x, ball_y, radius, YELLOW);
}

void initPaddle(){
    paddle_x1 = 43;
    paddle_y1 = 120;
    paddle_x2 = 84;
    paddle_y2 = 122;
    uLCD.filled_rectangle(paddle_x1,paddle_y1,paddle_x2,paddle_y2, YELLOW);
}

void initBricks(){

    int y1;
    int y2;
    bricks.color[0] = GREEN;
    bricks.color[1] = PURPLE;
    bricks.color[2] = ORANGE;
    bricks.color[3] = CYAN;
    bricks.color[4] = RED;
    bricks.color[5] = BLUE;
    
    y1 = -9;
    y2 = 0;    
    for (int i = 0; i < 3; i++){
        
        bricks.x1[i] = 1;
        bricks.y1[i] = y1 + 10;
        y1 = bricks.y1[i];
        
        bricks.x2[i] = 63;
        bricks.y2[i] = y2 + 10;
        y2 = bricks.y2[i];
        bricks.brickLife[i] = true;
        
        uLCD.filled_rectangle(bricks.x1[i],bricks.y1[i],bricks.x2[i],bricks.y2[i], bricks.color[i]);
    }
    
    y1 = -9;
    y2 = 0;    
    for (int i = 3; i < 6; i++){
        
        bricks.x1[i] = 64;
        bricks.y1[i] = y1 + 10;
        y1 = bricks.y1[i];
        
        bricks.x2[i] = 126;
        bricks.y2[i] = y2 + 10;
        y2 = bricks.y2[i];
        bricks.brickLife[i] = true;
        
        uLCD.filled_rectangle(bricks.x1[i],bricks.y1[i],bricks.x2[i],bricks.y2[i], bricks.color[i]);
    }
}

void initGame(){
    uLCD.cls();
    uLCD.background_color(BLACK);
    life = 5;
    initBall();
    initBricks();
    initPaddle();
    //code to initialize new game here
}

void playSound(void const *args){
    while(true){
        if(collision == true){
            wave_file=fopen("/sd/wavfiles/BOUNCE2.wav","r");
            waver.play(wave_file); //Plays *.wav audio file
            fclose(wave_file); //fclose yet? or wait first? wait after?
        }
        /*if(loss == true){
            wave_file=fopen("/sd/wavfiles/BUZZER.wav","r");
            waver.play(wave_file); //Plays *.wav audio file
            fclose(wave_file); //fclose yet? or wait first? wait after?
        }*/
    }       
}

void beginRound(){
    movement = true;
    dx = 1;
    dy = -1;
}

void endRound(){
    uLCD.filled_rectangle(paddle_x1,paddle_y1,paddle_x2,paddle_y2, BLACK);
    uLCD.filled_circle(ball_x, ball_y, radius, BLACK);//erase
    life--;
    movement = false;
    initBall();
    initPaddle();
}

void updateBall(){
    uLCD.filled_circle(ball_x, ball_y, radius, BLACK);//erase ball
    ball_x = ball_x + dx; //update x position
    ball_y = ball_y + dy; //update y position
    ball_x = (int)ball_x;//cast to int for reuse in draw function
    ball_y = (int)ball_y;
    uLCD.filled_circle(ball_x, ball_y, radius, YELLOW); //redraw ball
}

void updatePaddle(){
     if (!((paddle_x1 <= 0)&&(paddle_dx < 0)) && !((paddle_x2 >= 127)&&(paddle_dx > 0))){     
     uLCD.filled_rectangle(paddle_x1,paddle_y1,paddle_x2,paddle_y2, BLACK);
     paddle_x1 = paddle_x1 + paddle_dx;
     paddle_x2 = paddle_x2 + paddle_dx;
     paddle_x1 = (int)paddle_x1;
     paddle_x2 = (int)paddle_x2;
     uLCD.filled_rectangle(paddle_x1,paddle_y1,paddle_x2,paddle_y2, YELLOW);
     }
}

void tactSwitch(){
    //while(true){
        if(myNav.left()){
            paddle_dx = -1;
        }
        if(myNav.right()){
            paddle_dx = 1;
        }
        if(myNav.up()){
            if (dx>=0){
                dx++;
            }
            if (dx<0){
                dx--;
            }
            if (dy>=0){
                dy++;
            }
            if (dy<0){
                dy--;
            }
        }
        if(myNav.down()){
            if (dx>=0){
                dx--;
            }
            if (dx<0){
                dx++;
            }
            if (dy>=0){
                dy--;
            }
            if (dy<0){
                dy++;
            }
        }
        updatePaddle();
    //}
}

void outputImage(){
    uLCD.media_init();
    uLCD.set_sector_address(0x00, 0x00);
    uLCD.display_image(0,0);
    //wait?
}

void pauseDebugBall(){
    uLCD.locate(0,0);
    uLCD.printf("(%d, %d)", (int)ball_x+radius, (int)ball_y+radius);
    //while (pb1 == 1){}
}

void pauseDebugBrick(){
    uLCD.locate(0,5);
    uLCD.printf("(%d, %d, %d, %d)", bricks.x1[5], bricks.y1[5], bricks.x2[5], bricks.y2[5]);
    while (pb1 == 1){}
}

void pauseDebugPaddle(){
    uLCD.locate(0,1);
    uLCD.printf("(%d, %d, %d, %d)", (int)paddle_x1, (int)paddle_y1, (int)paddle_x2, (int)paddle_y2);
    while (pb1 == 1){}
}
    

void adjustSpeed(){}


int main() {
    
    Thread thread1(playSound);
    //Thread thread2(tactSwitch);
    
    pb1.mode(PullUp);

    initGame();//life set to 5
   
    while(1){//main game loop
    
        //if game is lost, restart
        if ((life == 0) && (movement == false)){
            outputImage();
            initGame();
        }
        
        //if round is lost, begin next round by pressing push button
        if ((pb1 == 0) && (movement == false)){
            beginRound();//movement = true
            while (movement == true){
                collision = false;
                //if ball falls below paddle, end round
                if (ball_y>=126-radius){
                    loss = true;
                    endRound();//should break out of while loop, stops movement
                    loss = false;
                }
                //if ball hits left or right side, reverse x direction
                if ((ball_x<=radius+1) || (ball_x>=126-radius)){
                    dx = -dx;
                    collision = true;
                }
                //if ball hits roof, reverse direction
                if (ball_y<=radius+1){
                    dy = -dy;
                    collision = true;
                }
                //paddle collision
                if (((ball_y+radius>=paddle_y1)&&(ball_y+radius<=paddle_y2))||((ball_y-radius>=paddle_y1)&&(ball_y-radius<=paddle_y2))){
                    if (((ball_x+radius>=paddle_x1)&&(ball_x+radius<=paddle_x2))||((ball_x-radius>=paddle_x1)&&(ball_x-radius<=paddle_x2))){
                        if ((ball_x<=paddle_x1)||(ball_x>=paddle_x2)){
                            dx = -dx;
                        }
                        else{
                            dy = -dy;
                        }
                        collision = true;
                    }
                }                
                //brick collision
                for (int i = 0; i < 6; i++){
                    if (((ball_y+radius>=bricks.y1[i])&&(ball_y+radius<=bricks.y2[i]))||((ball_y-radius>=bricks.y1[i])&&(ball_y-radius<=bricks.y2[i]))){
                        if (((ball_x+radius>=bricks.x1[i])&&(ball_x+radius<=bricks.x2[i]))||((ball_x-radius>=bricks.x1[i])&&(ball_x-radius<=bricks.x2[i]))){
                            if(bricks.brickLife[i]==true){
                                uLCD.filled_rectangle(bricks.x1[i],bricks.y1[i],bricks.x2[i],bricks.y2[i], BLACK);
                                bricks.brickLife[i] = false;
                                if ((ball_x<=bricks.x1[i])||(ball_x>=bricks.x2[i])){
                                    dx = -dx;
                                }
                                else{
                                    dy = -dy;
                                }
                                collision = true;
                            }
                        }
                    }
                }
                tactSwitch();
                //updatePaddle();                       
                updateBall();//redraws ball in new position (actually moves the ball)
                
            }//while loop for when ball is moving
        }//if statement for begin round
    }//main game loop
}//main
        

   
   
   
   
   
   
   
   
  