#include "mbed.h"
#include "terminal.h"

Serial *pPCTerminal;
void initializePCTerminal(Serial *p)
{
    pPCTerminal = p;
}


void clearScreen() 
{
    pPCTerminal->printf("\033[2J");
}

void locateCursor(int column, int row) 
{
    // Cursor Home    <ESC>[{ROW};{COLUMN}H
    pPCTerminal->printf("\033[%d;%dH", row + 1, column + 1);
}

int rgb888tobgr111(int colour) 
{
    int r = (colour >> 23) & 1;
    int g = (colour >> 15) & 1;
    int b = (colour >> 7) & 1;
    return (b << 2) | (g << 1) | (r << 0);
}

void setForeground(int colour) 
{
    // Set Attribute Mode    <ESC>[{n}m
    // Foreground Colours : 30 + bgr
    int c = 30 + rgb888tobgr111(colour);
    pPCTerminal->printf("\033[%dm", c);
}

void setbBackground(int colour) 
{
    // Set Attribute Mode    <ESC>[{n}m
    // Background Colours : 40 + bgr
    int c = 40 + rgb888tobgr111(colour);
    pPCTerminal->printf("\033[%dm", c);
}

void drawBox(int width, int height)
{
    pPCTerminal->printf("\0154");
    for(int i = 1; i < (width - 2); i++)pPCTerminal->printf("%c",157);
    pPCTerminal->printf("\0153 \n\r");
    
    for(int row = 1; row < (height - 2); row++)
        { 
        pPCTerminal->printf("\0170");
        for(int i = 1; i < (width - 2); i++)pPCTerminal->printf(" ");
        pPCTerminal->printf("\0170\n\r");
        }
   
    
    pPCTerminal->printf("\0155");
    for(int i = 1; i < (width - 2); i++)pPCTerminal->printf("\0163");
    pPCTerminal->printf("\052");

}