#include "mbed.h"

#include "./Parser.h"
#include "./terminal.h"

#define DEBUG_CMD_PROCESS

#define LED_ON   1
#define LED_OFF  0
DigitalOut AlarmLED(LED1);


#define RXBUFFERSIZE    128
#define RXBUFFERMASK    0x7F
char receiveBuffer[RXBUFFERSIZE];
unsigned char insertPointRxBuffer;

Serial pc(USBTX, USBRX);            // tx, rx 
void characterReceivedFromPC();
char globalStartofSentence;
bool globalSentenceFromPCReady;
//extern    char *commandTokens[20];




// initializeRingBufferAndTokenArray: -----------------------------------------
//
//
//-----------------------------------------------------------------------------
void initializeRingBufferAndTokenArray()
{
    insertPointRxBuffer = 0;
    globalStartofSentence = 0;

    globalSentenceFromPCReady = false;

    //make sure the array is full of address 0x000's
    for (int i = 0; i< 20; i++) {
        commandTokens[i] = NULL;
        }
}//eo initializeRingBufferAndTokenArray:: =====================================




// initializeSystem: ----------------------------------------------------------
//
//
//-----------------------------------------------------------------------------

void initializeSystem(void)
{
//    lcd.printf("Hi Brad\n");
//    lcd.locate(0,1);
//    lcd.printf("row 2\n");
 
    initializeRingBufferAndTokenArray();
    initializePCTerminal(&pc);
    clearScreen();
    
    locateCursor(0, 2);
    drawBox(30, 10);
    pc.attach(characterReceivedFromPC);  // set calback function to be called when a character is received
    
    AlarmLED = LED_ON;
    wait(0.2);  //wait .2 seconds
    AlarmLED = LED_OFF;
    wait(0.2);  //wait .2 seconds
    AlarmLED = LED_ON;
    wait(0.2);  //wait .2 seconds
    AlarmLED = LED_OFF;
}//eo initializeSystem:: ======================================================




// characterReceivedFromPC: ---------------------------------------------------
//
//
//-----------------------------------------------------------------------------

void characterReceivedFromPC()
{
    static unsigned char StartofNextSentence = 0;
    while(pc.readable()) 
        {
        receiveBuffer[insertPointRxBuffer] = pc.getc();
        if( receiveBuffer[insertPointRxBuffer] == '$' )
            {
            StartofNextSentence = insertPointRxBuffer;
            }
        if( receiveBuffer[insertPointRxBuffer] == '\r' ) 
            {
            receiveBuffer[insertPointRxBuffer] = '\0';

            //makeSentence available to main loop
            globalStartofSentence = StartofNextSentence;
            globalSentenceFromPCReady = true;
            printf("\n\rsentence rec %s\n\r", &receiveBuffer[StartofNextSentence]);
            }
        insertPointRxBuffer = (insertPointRxBuffer + 1) & RXBUFFERMASK;
        }
}//eo characterReceivedFromPC:: ===============================================



// processCommandMessage: -----------------------------------------------------
// transfer one sentence from incoming receive buffer into a command buffer for parsing
//
// 
//-----------------------------------------------------------------------------

void processCommandMessage()
{
    unsigned char fp = globalStartofSentence;  // initalize fetch point from receive buffer
    unsigned char ip = 0;                // initilize insert point into command buffer
    
    // copy the sentence (which contains a command) from the ring buffer (named receiveBuffer) 
    // into a normal linear array named commandBuffer
    char commandBuffer[60];
    #ifdef DEBUG_CMD_PROCESS
    printf("\n\r^^Start of sentence:%d\n\r",  fp);
    #endif
    while(receiveBuffer[fp] != '\0') 
        {
        #ifdef DEBUG_CMD_PROCESS
        if(pc.writeable()) pc.putc(receiveBuffer[fp]);
        #endif
        commandBuffer[ip] = receiveBuffer[fp];
        ip++;
        fp = (fp+1) & RXBUFFERMASK;
        }
    commandBuffer[ip] = '\0';
    
    parseCommandSentence(commandBuffer);

    #ifdef DEBUG_CMD_PROCESS
    // print out the tokens back to the terminal
    {
    int  i = 0;  
    while (strcmp(commandTokens[i],"END OF TOKENS" )) {
        pc.printf("$token %i: %s\n\r",i, commandTokens[i]);
        i++;     
        }
    }
    #endif
        
    if(strcmp(commandTokens[0],"$ST" )== 0) 
        {
        long newtime = atol(commandTokens[1]); 
        #ifdef DEBUG_CMD_PROCESS
        pc.printf("Setting time to: %l \n\r ", newtime);
        #endif
        set_time( newtime); 
        //int limitValue = atoi(commandTokens[3]);
        //if( *commandTokens[2] == 'U') setUpperLimitForChannel(channel, limitValue);   
        //if( *commandTokens[2] == 'L') setLowerLimitForChannel(channel, limitValue);                
        }
}//eo processCommandMessage:: =================================================



// main: ----------------------------------------------------------------------
//
//
//-----------------------------------------------------------------------------

int main() {
     set_time(1256729737);
    initializeSystem();
    
    while(1) 
        {//so infinite loop ...................................................
        if( globalSentenceFromPCReady == true ) 
            {
            processCommandMessage();
            globalSentenceFromPCReady = false;
            }
        
        time_t seconds = time(NULL);
        
        printf("Time as seconds since January 1, 1970 = %d\n", seconds);
        
        printf("Time as a basic string = %s", ctime(&seconds));
 
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        printf("Time as a custom formatted string = %s", buffer);
        
        
       
        AlarmLED = LED_OFF;
        wait(10);
        AlarmLED = LED_ON;
        wait(1);
        }//eo infinite loop :::::::::::::::::::::::::::::::::::::::::::::::::::
        
}//eo main ====================================================================

 