#include "./Parser.h"
#include <string.h>
#include <stdio.h>

 char *commandTokens[20];
 char invalidMessage[]     = "INVALID NEMA SENTENCE";
 char endOfTokensMessage[] =  "END OF TOKENS";
 
char validateCommandSentence(char *pSentence)
{
    char chkSumToken[3];
    unsigned char calculatedChecksum = 0;
    char errorCode = NOERROR;
    printf("\n\r\n\r>>>>>>>>>>>> %s <<<<\n\n\n\r", pSentence);
    if(*pSentence != '$')
        {
        printf("error no $\n\r");
        return ERROR;
        }
    pSentence++;
    
    while (*pSentence != '\0' && *pSentence != '*') {
        calculatedChecksum ^= *pSentence;
        pSentence++;
    }
    
    if(*pSentence == '*'){
        sprintf(chkSumToken, "%02x", calculatedChecksum);
        printf("Calc chksum %s<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\r", chkSumToken);
        pSentence++;
        if(strcmp(pSentence, chkSumToken) != 0)
            {
            printf("checksum error>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            errorCode = ERROR;
            }
        }
    else {
        printf("error:***** %s\n\r",pSentence);
        errorCode = ERROR;
        }
   
    printf("<<<<< errorcode %d\n\r", errorCode);
    return errorCode;
}

// parseCommandSentence() requires that the trailing <cr><lf> characters
// be removed prior to calling this function. Failing to do so will cause
// validateNemaSentence() to report an ERROR

void parseCommandSentence( char *pBuffer)
{
    if (validateCommandSentence(pBuffer) == ERROR) {
        commandTokens[0]= invalidMessage;
        commandTokens[1]= endOfTokensMessage;
        }
    else{
        //so valid sentence ...................................
        int tokenCounter = 0;
        
        commandTokens[tokenCounter]=pBuffer;
        pBuffer++;
        tokenCounter++;
        
        while( *pBuffer != '\0'){
            //until the end of sentence is found,
            //search for comma deliminators
            if(*pBuffer == ','){
                //found end of token
                *pBuffer = '\0';    //replace deliminator with a null character
                
                pBuffer++;          // save address of next token
                commandTokens[tokenCounter]=pBuffer;               
                tokenCounter++;
                }
            else pBuffer++;
            }//eo while not end of string
        commandTokens[tokenCounter] = endOfTokensMessage;
      
        }//eo Valid sentence:::::::::::::::::::::::::::::::::::::
    
}//eo parseNemaSentence( char *pBuffer) ========================================


//calculate a XOR checksum for a string
char calcChecksum(char *pSentence)
{
    unsigned char calculatedChecksum = 0;
    
    while (*pSentence != '\0' ) {
        calculatedChecksum ^= *pSentence;
        pSentence++;
    }
    return calculatedChecksum;
}
