//
//  menuItem.cpp
//  menuSystem
//
//  Created by BradDSmith on 2013-02-26.
//  Copyright (c) 2013 BradDSmith. All rights reserved.
//

#include "menuItem.h"
#include "console.h"

menuItem::menuItem():Text("EMPTY")
{
    
    
}

void menuItem::initialize( int ID, const char * text, int x, int y)
{
    menuID = ID;
    setText( (char *) text);
    setPosition(x,y);
}

void menuItem::setText( char * menuText)
{
    Text.assign(menuText);
}

void menuItem::setPosition(int x, int y)
{
    position.X =  x;
    position.Y  = y;
}

void menuItem::print()
{
    const char * msg = Text.c_str();
    printXY( (char *)msg, position.X, position.Y);
 
}
void menuItem::erase()
{
    printXY ("                                           ", position.X - 2, position.Y);
}

void menuItem::highlight()
{
    printXY ("X", position.X - 2, position.Y);
    gotoxy( position.X - 2, position.Y);
}

void menuItem::removeHighLight()
{
    printXY (" ", position.X - 2, position.Y);

}

int menuItem::getMenuID()
{
    return menuID;
}


