#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[12];


int FilterPageHandler()
{
     int userSelection = 0;
     pageMenu[FILTER].printMenu();

     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[FILTER].erase();
                    printXY("                          ", 5, 10);    //erases the ACTION prompt
                    userSelection = RECORDSET;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[FILTER].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[FILTER].highlightNextItem();
                    break;
                case 0x07:
                    userSelection = pageMenu[FILTER].getHighlightedItem() ;
                    break;
                }//eo select

                // is hte user selection an ACTION  assigned to this page
                if (userSelection != 0 && userSelection > FILTEROFFSET)  //page selections are 0 through 12
                    {
                    // place code here to handle actions processed directly from this page
                    switch(userSelection)
                        {
                        case FILTER1:
                            printXY("Filter 1 selected      ", 5, 10);
                            //call function to perform task
                            break;
                        case FILTER2:
                            printXY("FIlter 2 selected     ",5,10);
                            //call function to perform task
                            break;
                        case FILTER3:
                            printXY("Filter 3 selected      ", 5, 10);
                            //call function to perform task
                            break;
                        case FILTERNONE:
                            printXY("No filter selected    ",5,10);
                            //call function to perform task
                            break;
                        }
                    // eo place code here ......
                    userSelection = 0;
                    }
            wait_ms(200);
            }//eo if kbhit
        }//eo while
        return userSelection;
}
