
#include "mbed.h"

#define RGBLEDON  0
#define RGBLEDOFF 1

#define LEDON  1
#define LEDOFF 0

#define GREENLED  PTA4
#define YELLOWLED PTA12
#define REDLED    PTD4



Serial terminal(USBTX, USBRX);    

DigitalOut myGreenLED(GREENLED, LEDOFF);  //PTD1
DigitalOut myRedLED(REDLED, LEDOFF);    //PTB18

DigitalIn Switch1(PTD5);


int main() {
    myGreenLED = LEDOFF;
    myRedLED = LEDOFF;
 
    int counter = 0;
 
    while(1)  
        { 
        int switchpos = Switch1.read();
        terminal.printf("Switch pos %d\n", switchpos);  /* TeraTerm -> Setup Terminal newl ine: set to LF */
                                                        /* otherwise add \r                                    */    
        counter++;         
            
        if( Switch1.read() == 1)
            {
            myRedLED = LEDON;
            wait(.2);
            myRedLED = LEDOFF;
            wait(0.2);
            }
        else
            {
            myGreenLED = LEDON;
            wait(.5);
            myGreenLED = LEDOFF;
            wait(0.5);
            }
        }
}
