/* Copyright (C) 2014 Murata Manufacturing Co.,Ltd., MIT License
 *  muRata, SWITCH SCIENCE Wi-FI module TypeYD SNIC-UART.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "TCPSocketServer.h"

Serial pc(USBTX, USBRX);


#define WIFI_SSID                  "demossid"
#define WIFI_SECURITY_TYPE         e_SEC_OPEN
#define WIFI_SECUTIRY_KEY          "WPA2_PASSPHRASE"
#define WIFI_SECUTIRY_KEY_LEN      15

//#define WIFI_SSID                  "AP_SSID"
//#define WIFI_SECURITY_TYPE         e_SEC_WPA2_AES
//#define WIFI_SECUTIRY_KEY          "WPA2_PASSPHRASE"
//#define WIFI_SECUTIRY_KEY_LEN      15


C_SNIC_WifiInterface     wifi( D1, D0, NC, NC, D3 );

int wifiInit()
{
    int check = 0;

    // Initialize Wi-Fi interface
    check = wifi.init();
    if( check != 0 ) {
        printf( "Wifi could not be initialized, halting.\r\n" );
        return -1;
    } else {
        printf("wifi initialized successfully!\r\n");
    }
    wait(0.5);

    // good form to make sure you are disconnected from all AP's
    check = wifi.disconnect();
    if( check != 0 ) {
        printf( "disconnect failed\r\n" );
        return -1;
    } else {
        printf("disconnection successful!\r\n");
    }
    wait(0.3);

    // Connect AP
    check = wifi.connect( WIFI_SSID
                          , strlen(WIFI_SSID)
                          , WIFI_SECURITY_TYPE
                          , WIFI_SECUTIRY_KEY
                          , WIFI_SECUTIRY_KEY_LEN );
    if( check != 0) {
        printf("Connect Failed\r\n");
    } else {
        printf("connected successfully!\r\n");
    }
    wait(0.5);

    // Get DHCP IP
    check = wifi.setIPConfig( true ); // get IP as DHCP IP
    if(check != 0) {
        printf("SetIPConfig failed \r\n");
    } else {
        printf("SetIPConfig successful \r\n");
    }

    // check IP Address
    char * ip ;
    ip = wifi.getIPAddress();
    if(ip == 0) {
        printf("getIP failed. \r\n");
    } else {
        printf("getIP success: %s \r\n",ip);
    }
}

//
// main loop
//
int main()
{

    // Initialize Wifi
    wifiInit();

    // TCP Schenanigans!
    const char* ECHO_SERVER_ADDRESS = "192.168.11.3";
    const int ECHO_SERVER_PORT = 7;

    // connect to server
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n\r", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }

    // send messages back and forth as long as we are connected
    int x = 0;
    while(socket.is_connected()) {
        // Setup & send message to server
        char message[64] = {};
        sprintf(message,"%s%d","HelloFromMicrocontroller: ",x++);
        socket.send_all(message, sizeof(message) - 1);

        // Receive & print message from server
        char buf[256];
        int n = socket.receive_all(buf, 256);
        buf[n] = '\0';
        printf("TCP data from server: '%s'", buf);

        // not needed, here to slow the data down so you can see it whip past.
        wait(0.5);
    }

    socket.close();
    wifi.disconnect();

    while(true) {}

}
