/* Copyright (C) 2014 Murata Manufacturing Co.,Ltd., MIT License
 *  muRata, SWITCH SCIENCE Wi-FI module TypeYD SNIC-UART.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "SNIC_WifiInterface.h"

#define XI_FEED_ID 1056160623 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "Wg7CfZDrj7VjIIpiYzdDrMow6wdENAOGjkIfQ0fUjJh6DAw2" // set Xively API key (double-quoted string)

#include "app_board_io.h"

#include "xively.h"
#include "xi_err.h"

#include "MMA7660.h"
#include "LM75B.h"
#include "C12832.h"

#if defined(TARGET_LPC1768)
#include "PowerControl/EthernetPowerControl.h"
C12832 lcd(p5, p7, p6, p8, p11);
MMA7660 axl(p28, p27);
LM75B tmp(p28, p27);
#elif defined(TARGET_LPC1549)
C12832 lcd(D11, D13, D12, D7, D10);
MMA7660 axl(SDA, SCL);
LM75B tmp(SDA, SCL);
#endif

#include "logo.h"

#define DEMO_AP_SSID                  "E2N1-Lab-Buffalo-D302"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_AES
#define DEMO_AP_SECUTIRY_KEY          "12345678"
#define DEMO_AP_SECUTIRY_KEY_LEN      8

/** Wi-Fi SNIC UART Interface*/
#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface     mSNICwifi( p9, p10, NC, NC, p30 );
Serial pc(USBTX, USBRX);    /* for DEBUG_PRINT */
#elif defined(TARGET_LPC1549)
C_SNIC_WifiInterface     mSNICwifi( D0, D1, NC, NC, D3 );
Serial pc(P2_12, P2_11);    /* for DEBUG_PRINT */
#endif

int main() {
    
#if defined(TARGET_LPC1768)
    PHY_PowerDown();
#endif
    pc.baud( 115200 );
    DEBUG_PRINT("main\r\n");
    lcd_print_xively_logo();
    
    // Initialize Wi-Fi interface
    int s = mSNICwifi.init();
    
    lcd_printf("init();\r\n");
    
    if( s != 0 )
    {
        lcd_printf( "Could not initialise. Will halt!\n" );        
        return -1;
    }    
    wait(0.5);
    s = mSNICwifi.disconnect();
    lcd_printf("disconnect();\r\n");
    if( s != 0 )
    {
        printf( "disconnect failed\r\n" );        
        return -1;
    }    
    
    wait(0.3);
    // Connect AP
    mSNICwifi.connect( DEMO_AP_SSID
                        , strlen(DEMO_AP_SSID)
                        , DEMO_AP_SECURITY_TYPE
                        , DEMO_AP_SECUTIRY_KEY
                        , DEMO_AP_SECUTIRY_KEY_LEN );
    lcd_printf("connect();\r\n");
    wait(0.5);
    
    lcd_printf("IP Config();\r\n");
    mSNICwifi.setIPConfig( true );
    
    wait(0.5);

    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );
    
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 3;
    
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* orientation_datastream = &feed.datastreams[0];
    strcpy( orientation_datastream->datastream_id, "orientation" );
    xi_datapoint_t* current_orientation = &orientation_datastream->datapoints[0];

    feed.datastreams[1].datapoint_count = 1;
    xi_datastream_t* side_rotation_datastream = &feed.datastreams[1];
    strcpy( side_rotation_datastream->datastream_id, "side_rotation" );
    xi_datapoint_t* current_side_rotation = &side_rotation_datastream->datapoints[0];
    
    feed.datastreams[2].datapoint_count = 1;
    xi_datastream_t* temperature_datastream = &feed.datastreams[2];
    strcpy( temperature_datastream->datastream_id, "temperature" );
    xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];
    
    // create the cosm library context
    xi_context_t* xi_context
        = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL )
    {
        return -1;
    }

    while(1) {
      switch( axl.getSide() ) {
        case MMA7660::Front:
          xi_set_value_str( current_side_rotation, "front" );
          break;
        case MMA7660::Back:
          xi_set_value_str( current_side_rotation, "back" );
          break;
        default:
          xi_set_value_str( current_side_rotation, "unknown" );
          break;
      }
      
      switch( axl.getOrientation() ) {
        case MMA7660::Down:
          xi_set_value_str( current_orientation, "down" );
          break;
        case MMA7660::Up:
           xi_set_value_str( current_orientation, "up" );
           break;
        case MMA7660::Right:
          xi_set_value_str( current_orientation, "right" );
          break;
        case MMA7660::Left:
          xi_set_value_str( current_orientation, "left" );
          break;
        default: 
          xi_set_value_str( current_orientation, "unknown" );
          break;
      }
      
      xi_set_value_f32( current_temperature, tmp.read() );
        
      lcd_printf( "update...\n" );
      xi_feed_update( xi_context, &feed );
      lcd_printf( "done...\n" );
      
      wait( 1.0 );
    }
}
