#include "mbed.h"

#include "UbloxUSBCDMAModem.h"
#include "UbloxUSBGSMModem.h"
#define MODEM_UBLOX_CDMA // remove this if you are using GSM

#define XI_FEED_ID 248 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "T4KXAH_dasgw1PWBsfsdgy-dUc4ND0g" // set Xively API key (double-quoted string)

#include "cellular_board_io.h"

#include "xively.h"
#include "xi_err.h"

int main() {

//TODO: maybe move these into board_io files and do it for app board ethernet version too...
#ifdef MODEM_UBLOX_CDMA
    UbloxUSBCDMAModem modem(p18, true, 1);
#else
    UbloxUSBGSMModem modem;
#endif

    modem.power(true);
    Thread::wait(1000);

    int s = modem.connect(NULL, NULL, "internet");
    
    if( s )
    {
        printf( "Could not connect to the Internet. Will halt!\r\n" );
        exit( 0 );
    }
    
    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );
    
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 1;
    
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* counter_datastream = &feed.datastreams[0];
    strcpy( counter_datastream->datastream_id, "counter" ); 
    xi_datapoint_t* counter = &counter_datastream->datapoints[0];

    //TODO:
    //- figure out how got send `AT$DEBUG?` command and parse it's ouput which looks like:
    // $DEBUG: 4183,233,100,1,99,-9,-105,2,2,2,93,261,429,186,249,438,21,63,63,63,63,63
    // For details see docs: http://www.u-blox.com/images/downloads/Product_Docs/LISAC200-FW75C200_ATCommandsManual_%28CDMA-2X-11002%29.pdf)
    // Some of these values represent varios interesting things, e.g. RSSI.
    // We should put some of those into separate Xively datastreams...
    
    // create the cosm library context
    xi_context_t* xi_context
        = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL )
    {
        return -1;
    }
    long unsigned int c = 0; 
    while(1) {
      
      xi_set_value_i32( counter, ++c );
        
      printf( "Updating Xively feed %d...\r\n", XI_FEED_ID );
      xi_feed_update( xi_context, &feed );
      printf( "   done!\r\n" ); //TODO: add error check, as cellular can be flaky.
      
      wait( 50.0 );
    }
}
