/* Copyright (C) 2014 Murata Manufacturing Co.,Ltd., MIT License
 *  muRata, SWITCH SCIENCE Wi-FI module TypeYD SNIC-UART.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "SNIC_WifiInterface.h"

Serial pc(USBTX, USBRX);


#define WIFI_SSID                  "AP_SSID"
#define WIFI_SECURITY_TYPE         e_SEC_WPA2_AES
#define WIFI_SECUTIRY_KEY          "WPA2_PASSPHRASE"
#define WIFI_SECUTIRY_KEY_LEN      15

C_SNIC_WifiInterface     wifi( D1, D0, NC, NC, D3 );

int main()
{
    // for built in debug printouts
//    pc.baud( 115200 ); 

    // Initialize Wi-Fi interface
    if( wifi.init() != 0 ) {
        printf( "Wifi could not be initialized, halting.\r\n" );
        return -1;
    }else {
        printf("wifi initialized successfully!\r\n");
    }
    wait(0.5);
    
    // good form to make sure you are disconnected from all AP's
    if( wifi.disconnect() != 0 ) {
        printf( "disconnect failed\r\n" );
        return -1;
    }else{
        printf("disconnection successful!\r\n");
        }
    wait(0.3);
    
    // Connect AP
    wifi.connect( WIFI_SSID
                       , strlen(WIFI_SSID)
                       , WIFI_SECURITY_TYPE
                       , WIFI_SECUTIRY_KEY
                       , WIFI_SECUTIRY_KEY_LEN );
    printf("connect();\r\n");
    wait(0.5);

    printf("IP Config();\r\n");
    wifi.setIPConfig( true );

    printf( "done...\n" );

    wait( 1.0 );
}
