#include "mbed.h"
#include "EthernetInterface.h"

#define XI_FEED_ID 128488 // set Xively Feed ID (numerical, no quoutes
#define XI_API_KEY "T4KXAH_dasgw1PWBPc3fdsfsdgsdy-dUc4ND0g" // set Xively API key (double-quoted string) 

#include "app_board_io.h"

#define XI_DEBUG_PRINTF lcd_printf
#define XI_DEBUG_OUTPUT 1
#define XI_DEBUG_ASSERT 0

#include "xively.h"
#include "xi_err.h"

MMA7660 axl(p28, p27);
LM75B tmp(p28, p27);

int main() {
    
    EthernetInterface eth;
    
    int s = eth.init(); //Use DHCP
    
    if( s != NULL )
    {
        lcd_printf( "Could not initialise. Will halt!\n" );        
        exit( 0 );
    }    
        
    s = eth.connect();
    
    if( s != NULL )
    {
        lcd_printf( "Could not connect. Will halt!\n" );
        exit( 0 );
    }
    else 
    {
        lcd_printf( "IP: %s\n", eth.getIPAddress() );    
    }
    
    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );
    
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 3;
    
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* orientation_datastream = &feed.datastreams[0];
    strcpy( orientation_datastream->datastream_id, "orientation" );
    xi_datapoint_t* current_orientation = &orientation_datastream->datapoints[0];

    feed.datastreams[1].datapoint_count = 1;
    xi_datastream_t* side_rotation_datastream = &feed.datastreams[1];
    strcpy( side_rotation_datastream->datastream_id, "side_rotation" );
    xi_datapoint_t* current_side_rotation = &side_rotation_datastream->datapoints[0];
    
    feed.datastreams[2].datapoint_count = 1;
    xi_datastream_t* temperature_datastream = &feed.datastreams[2];
    strcpy( temperature_datastream->datastream_id, "temperature" );
    xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];
    
    // create the cosm library context
    xi_context_t* xi_context
        = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL )
    {
        return -1;
    }
    
    lcd_printf("feed:%d datastreams:[%s,%s]\n", feed.feed_id,
                    orientation_datastream->datastream_id,
                    side_rotation_datastream->datastream_id);

    while(1) {
      
      switch( axl.getSide() ) {
        case MMA7660::Front:
          xi_set_value_str( current_side_rotation, "front" );
          break;
        case MMA7660::Back:
          xi_set_value_str( current_side_rotation, "back" );
          break;
        default:
          xi_set_value_str( current_side_rotation, "unknown" );
          break;
      }
      
      switch( axl.getOrientation() ) {
        case MMA7660::Down:
          lcd_printf("down %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
          xi_set_value_str( current_orientation, "down" );
          break;
        case MMA7660::Up:
           lcd_printf("up %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
           xi_set_value_str( current_orientation, "up" );
           break;
        case MMA7660::Right:
          lcd_printf("right %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
          xi_set_value_str( current_orientation, "right" );
          break;
        case MMA7660::Left:
          lcd_printf("left %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
          xi_set_value_str( current_orientation, "left" );
          break;
        default: 
          xi_set_value_str( current_orientation, "unknown" );
          break;
      }
      
      xi_set_value_f32( current_temperature, tmp.read() );
        
      lcd_printf( "update...\n" );
      xi_feed_update(xi_context, &feed);
      lcd_printf( "done...\n" );
      
      wait( 15.0 );
    }
}