/* Copyright (C) 2014 Murata Manufacturing Co.,Ltd., MIT License
 *  muRata, SWITCH SCIENCE Wi-FI module TypeYD SNIC-UART.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "SNIC_WifiInterface.h"

Serial pc(USBTX, USBRX);


#define WIFI_SSID                  "demossid"
#define WIFI_SECURITY_TYPE         e_SEC_OPEN
#define WIFI_SECUTIRY_KEY          "WPA2_PASSPHRASE"
#define WIFI_SECUTIRY_KEY_LEN      15

//#define WIFI_SSID                  "AP_SSID"
//#define WIFI_SECURITY_TYPE         e_SEC_WPA2_AES
//#define WIFI_SECUTIRY_KEY          "WPA2_PASSPHRASE"
//#define WIFI_SECUTIRY_KEY_LEN      15


C_SNIC_WifiInterface     wifi( D1, D0, NC, NC, D3 );

// callback function used by scan()
// this function will be called on every network scanned
void scanCallbackFn(tagSCAN_RESULT_T *scan_result)
{
    printf("\r\n");
    printf("channel = %d \r\n"      ,scan_result->channel);
    printf("rssi = %d \r\n"         ,scan_result->rssi);
    printf("security = %d \r\n"     ,scan_result->security);
    printf("bssid = %x%x%x%x%x%x\r\n",scan_result->bssid[0],scan_result->bssid[1],scan_result->bssid[2],scan_result->bssid[3],scan_result->bssid[4],scan_result->bssid[5]);
    printf("network_type = %d \r\n" ,scan_result->network_type);
    printf("max_rate = %d \r\n"     ,scan_result->max_rate);
    printf("ssid = %s \r\n"         ,scan_result->ssid);
}

// main loop
int main()
{
    // for built in debug printouts
//    pc.baud( 115200 );

    int check = 0;

    // Initialize Wi-Fi interface
    check = wifi.init();
    if( check != 0 ) {
        printf( "Wifi could not be initialized, halting.\r\n" );
        return -1;
    } else {
        printf("wifi initialized successfully!\r\n");
    }
    wait(0.5);

    // good form to make sure you are disconnected from all AP's
    check = wifi.disconnect();
    if( check != 0 ) {
        printf( "disconnect failed\r\n" );
        return -1;
    } else {
        printf("disconnection successful!\r\n");
    }
    wait(0.3);

    // Connect AP
    check = wifi.connect( WIFI_SSID
                          , strlen(WIFI_SSID)
                          , WIFI_SECURITY_TYPE
                          , WIFI_SECUTIRY_KEY
                          , WIFI_SECUTIRY_KEY_LEN );
    if( check != 0) {
        printf("Connect Failed\r\n");
    } else {
        printf("connected successfully!\r\n");
    }
    wait(0.5);

    // Get DHCP IP
    check = wifi.setIPConfig( true ); // get IP as DHCP IP
    if(check != 0) {
        printf("SetIPConfig failed \r\n");
    } else {
        printf("SetIPConfig successful \r\n");
    }

    // Get RSSI
    signed char temp = 0;
    check = wifi.getRssi(&temp);
    if(check != 0) {
        printf("getRssi failed. \r\n");
    } else {
        printf("getRssi success: %d \r\n",temp);
    }

    // check IP Address
    char * ip ;
    ip = wifi.getIPAddress();
    if(ip == 0) {
        printf("getIP failed. \r\n");
    } else {
        printf("getIP success: %s \r\n",ip);
    }

    // get wifi status
    tagWIFI_STATUS_T status;
    check = wifi.getWifiStatus(&status);
    if(check != 0) {
        printf("getWifiStatus failed \r\n");
    } else {
        // Status 0=WifiOff, 1=No Network, 2=Connected to AP, 3=Started AP mode
        printf("getWifiStatus success: status =%d, MAC = %x%x%x%x%x%x, SSID = %s  \r\n",
               status.status,
               status.mac_address[0], status.mac_address[1],
               status.mac_address[2], status.mac_address[3],
               status.mac_address[4], status.mac_address[5],
               status.ssid );
    }

    // scan for wifi, results will be called in callback function
    check = wifi.scan(NULL,NULL,scanCallbackFn);
    if(check != 0) {
        printf("scan failed! \r\n");
    } else {
        printf("Scan Success! \r\n");

    }

//    if(check != 0){
//        printf(" \r\n");
//    }else{
//        printf(" \r\n");
//    }

    wait( 1.0 );
}
