#include "mbed.h"

// Program to use the  mbed as a serial bridge
//
RawSerial pc(USBTX, USBRX); // tx, rx
RawSerial dev(D1, D0); // tx, rx

void send()
{
    while (pc.readable()) {
        dev.putc(pc.getc());
    }
}

void recv()
{
    pc.putc(dev.getc());
}

int main()
{
    char c;

    // PC serial
    pc.baud(9600);
    pc.attach(send, Serial::RxIrq);

    // Device serial
    dev.baud(9600);

    wait(0.1);
    dev.printf("AT+RST\r\n"); // Reset esp device
    while(1) {
        c = dev.getc();
        pc.putc(c);
    }
}
