#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"

ESP8266Interface wifi(D1,D0,D2,"ssid","passkey",115200); // TX,RX,Reset,SSID,Password,Baud
RawSerial pc(USBTX, USBRX); // tx, rx

int main()
{
    pc.baud(9600);
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    printf("IP Address is %s \n\r", wifi.getIPAddress());
    TCPSocketConnection socket;
    
    // Initialize ifttt object, add up to 3 optional values, trigger event. 
    IFTTT ifttt("YourEventName","ChangeToYourSecretKey", &socket); // EventName, Secret Key, socket to use
    ifttt.addIngredients("this is awesome","test-ing","data!!!");     // 3 optional Values to send along with trigger.
    ifttt.trigger();

    ifttt.addIngredients("Sending","GET","data");
    ifttt.trigger(IFTTT_GET);

    ifttt.addIngredients("Sending","POST","things");
    ifttt.trigger(IFTTT_POST);
    while(1) {
    }
}
