
// Headers necessary for mbed and BLE device mode
#include "mbed.h"
#include "BLEDevice.h"

// BLE object
BLEDevice ble;

// Optional: Device Name, add for human read-ability
//const static char     DEVICE_NAME[]        = "ChangeMe!!"; // Optional: device name

// You have up to 26 bytes of advertising data to use.

//const static uint8_t AdvData[] = {"ChangeThisData"};         // example of character data
const static uint8_t AdvData[] = {0x01,0x02,0x03,0x04,0x05};   // example of hex data

// Optional: Restart advertising when phone app disconnects 
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason){
    ble.startAdvertising(); 
}

// main program
int main(void)
{
    // Initialize BLE baselayer, always do this first!
    ble.init();
    
    // Optional: add callback for disconnection
    // ble.onDisconnection(disconnectionCallback); 

    // Sacrifice 3B of 31B to Advertising Flags
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE );
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);

    // Sacrifice 2B of 31B to AdvType overhead, rest goes to AdvData array you define
    ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, AdvData, sizeof(AdvData));
    
    // Optional: Add name to device 
    //ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));

    // Set advertising interval. Longer interval = longer battery life
    ble.setAdvertisingInterval(100); // 100ms, set as percentage of a second
    ble.startAdvertising();

    // Infinite loop waiting for BLE events
    for (;;) {
        ble.waitForEvent(); // this saves battery while waiting for callback events
    }
}
