#include <mbed.h>
#include <scmRTOS.h>

Serial pc(USBTX, USBRX);

// process types
typedef OS::process<OS::pr0, 1000> TProc1;
typedef OS::process<OS::pr1, 1000> TProc2;

// process objects
TProc1 Proc1;
TProc2 Proc2;

//---------------------------------------------------------------------------
long long count = 0;

int main() {
    pc.baud(115200);
    printf("\nInitialising ...\n");
    OS::Run();
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc1::Exec() {
    for (;;) {
        Sleep(2000);
        printf("[1] %lld\n", count);
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc2::Exec() {
    for (;;) {
        Sleep(2000);
        printf("[2] %lld\n", count);
    }
}

//---------------------------------------------------------------------------
void OS::SystemTimerUserHook() {
    ++count;
    if (count % 2000 == 0) {
        printf("\n%lld\n", count);
    }
}

//---------------------------------------------------------------------------
void OS::IdleProcessUserHook() {
    __WFI();
}