#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"


Timer t;
DigitalOut led1(p25);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut rst1(p30);
DigitalOut buzzer(p17);
DigitalOut startl(p21);
DigitalIn  sensorBasis(p12);
DigitalIn  test(p23);
DigitalIn starta(p12);
I2C i2c(p28, p27);
Serial xbee1(p9, p10);
const int addr = 0x90;
int rondeTijden[3];
int rondeTijdenMilli[3];
int rondeTijdenM[3];
int stukCircuit=0;
int lapcounter;
int overzicht;
int circuit;
int tijds,tijdmilli,tijdm;
int tellerS=0,tellerM=0,data=125,status,i=3;
int start,i2cinfo1,i2cinfo2,i2cinfo3;
bool send;
char cmd[2];

LocalFileSystem local("local");
 
extern unsigned char p1[];  // the mbed logo graphic
 
// the display has a backlight switch on board 
DigitalOut LCD_LED(p21);       
 
// the TFT is connected to SPI pin 5-7
SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p15, p16,"TFT"); // mosi, miso, sclk, cs, reset, dc
  

void rondeTijden_thread(void const *args) {
    while (true) {
      if(sensorBasis == 1)
      {
         send=false;
         if(start == 0)
         {
            buzzer=1;
            if(lapcounter < 99)
            { 
                lapcounter++;
            }
            else{
                lapcounter=0;
            }
            t.reset();
            t.start();
            tijdm=0;
            Thread::wait(500);
            buzzer=0;
            start=1;
         }
         else
         {
            start=0;
            buzzer=0;
            send=true;
            rondeTijden[2]=rondeTijden[1];
            rondeTijden[1]=rondeTijden[0];
            rondeTijden[0]=tijds;
            rondeTijdenMilli[2]=rondeTijdenMilli[1];
            rondeTijdenMilli[1]=rondeTijdenMilli[0];
            int tijd=t.read();
            rondeTijdenMilli[0]=tijdmilli;
            rondeTijdenM[2]=rondeTijdenM[1];
            rondeTijdenM[1]=rondeTijdenM[0];
            rondeTijdenM[0]=tijdm;
            t.stop();
        }
      }
      else
      {
          led4=0;
      }       
    }
}
 

void meetStation_thread(void const *args) {
    while(1)
    {
    //startl=0;
    //Thread::wait(500);
    if(starta==1)
    {
    led1=0;
    for(int i=0 ; i<5; i++)
    {
    Thread::wait(500);
    startl=0;
    Thread::wait(500);
    startl=1;
    
    }
    Thread::wait(500);
    startl=0;
    Thread::wait(500);
    startl=1;
    led1=1;
    }
    led1=1;
    //for(int i=0 ; i<5; i++)
    //{
    //startl=1;
    //Thread::wait(0.1);
    //startl=0;
    //Thread::wait(0.1);
    //}
    
    }
}

void ethernet_receive_thread(void const *args) {
    while(1)
    {
    
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    //lcd.locate(0,10);
    //lcd.printf("IP Address is %s\n", eth.getIPAddress());
    TCPSocketConnection sock;
    sock.connect("192.168.0.100", 8006);
    char buffer[10];
    string ret;
    ret = sock.receive(buffer, sizeof(buffer)-1);
    TFT.locate(30,85);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.printf("%s",ret);
    
    }
 }
 
 
 
 void ethernet_transmit_thread(void const *args) {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    
    UDPSocket sock;
    sock.init();
    
    Endpoint nist;
    nist.set_address("192.168.0.100", 8005);
    while(1)
    {
        if(send)
        {
            //string buffer=snprintf("2%3d", lapcounter);
            //string buffer2=snprintf("3%3d.%3d", rondeTijden[0],rondeTijdenM[0]);
            
            //char out_buffer[] = {snprintf("1: %3d:%3d", rondeTijden[0],rondeTijdenM[0])}; // Does not matter
            //sock.sendTo(nist, out_buffer, sizeof(out_buffer));
            send=false;
        }
    }
 }
 
 
int main() {
    
    xbee1.baud(115200);
    Thread thread1(rondeTijden_thread);
    Thread thread2(meetStation_thread);
    //Thread thread3(ethernet_receive_thread);
    //Thread thread4(ethernet_transmit_thread);
    rst1 = 0;
    wait_ms(1);
    rst1 = 1;
    wait_ms(1);
        
       
            
            
    LCD_LED = 1;            // backlite on
    TFT.claim(stdout);        // send stdout to the TFT display
        TFT.set_orientation(1);
        TFT.background(White);    // set background to black
        TFT.foreground(Black);    // set chars to white
        TFT.cls();                // clear the screen
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.locate(5,5);
    TFT.printf("Racing robot");
    TFT.locate(30,150);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.printf("Overzicht Circuit:");
    TFT.locate(250,95);
    TFT.printf("Ronde:");
    TFT.locate(10,215);
    TFT.printf("© Ei:Joriek Rogge, Arne DeBergh");
    TFT.locate(10,227);
    TFT.printf("© Eo:Sven Priker, Alexander De Geeter");
    TFT.line(0,50,320,50,White);
    xbee1.baud(115200);
    
    while(1)
    {
    TFT.locate(20,40);
    tijds = (t.read()-(tijdm*60));
    tijdmilli = ((t.read()*100)-(tijds*100)-(tijdm*6000));
    //tijdm = tijds/60;
    if(tijds>=60)
    {
        tijdm++;
        tijds=0;
    }
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.printf("%-2d:%-2d:%-2d ",tijdm, tijds,tijdmilli);
    TFT.locate(240,110);
    TFT.printf("%-2d", lapcounter);
    //TFT.locate(30,85);
    //TFT.set_font((unsigned char*) Arial28x28);
    //TFT.printf("1: %-2d:%-2d:%-2d ",rondeTijdenM[0],rondeTijden[0],rondeTijdenMilli[0]);
    //TFT.locate(30,115);
    //TFT.printf("2: %-2d:%-2d:%-2d ",rondeTijdenM[1],rondeTijden[1],rondeTijdenMilli[1]);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.circle(275,65,15,Black);
    if(tijdmilli<80)
    {
        TFT.fillcircle(275,65,14,Black);
    }
    else
    {
        TFT.fillcircle(275,65,14,Red);
    }
    TFT.rect(10,170,110,210,Black);
    TFT.rect(110,170,210,210,Black);
    TFT.rect(210,170,310,210,Black);
    switch(circuit)
    {
        case 0:
        TFT.fillrect(11,171,109,209,Red);
        TFT.fillrect(111,171,209,209,Red);
        TFT.fillrect(211,171,309,209,Red);
        break;
        case 1:
        TFT.fillrect(11,171,109,209,Green);
        TFT.fillrect(111,171,209,209,Red);
        TFT.fillrect(211,171,309,209,Red);
        break;
        case 2:
        TFT.fillrect(11,171,109,209,Green);
        TFT.fillrect(111,171,209,209,Green);
        TFT.fillrect(211,171,309,209,Red);
        break;
        case 3:
        TFT.fillrect(11,171,109,209,Green);
        TFT.fillrect(111,171,209,209,Green);
        TFT.fillrect(211,171,309,209,Green);
        break;
     }   
    //wait_ms(20);
     }
}
