/**
    Header File
    Creates a Rational Number class -- and provides access to some operations on an object of this class
**/
class Rationals {
   public:
    int numerator, denominator;
   
   public:  
    Rationals();
    Rationals(int n, int d);
    
    float get();
    int getn();
    int getd();
};

Rationals::Rationals()
{
    numerator = 0;
    denominator = 1;
}

int gcd(int n,int m){return m==0?n:gcd(m,n%m);}

// store in factorized form
Rationals::Rationals(int n, int d)
{
    //n is a multiple of d
    if(n%d == 0) {
            n=n/d;
            d=1;       
        }
    // if n and d have a common factor
    int g;
    if( (g = gcd(n,d)) != 1) {
        n = n/g;
        d = d/g;
    }
    numerator = n;
    denominator = d;
}

int Rationals::getn()
{
    return numerator;
}

int Rationals::getd()
{
    return denominator;
}

float Rationals::get()
{
    return numerator;
}
