/**
    Header File
    Provides various functions for creating the SDF graph and populating the topology matrix
**/

// print numerators only of topology matrix
void printn( int edges, int nodes)
  {
    pc.printf("\r\n");
    for ( int i = 0; i < edges;i++)
    {
        for (int j = 0; j < nodes; j++)
            pc.printf("%d ", matrix[i][j].getn());
        pc.printf("\r\n");
    }
  
  }
  
// explode a line into words of type string
vector<string> explode( const string &delimiter, const string &str)
{
    vector<string> arr;

    int strleng = str.length();
    int delleng = delimiter.length();
    if (delleng==0)
        return arr;//no change

    int i=0; 
    int k=0;
    while( i<strleng )
    {
        int j=0;
        while (i+j<strleng && j<delleng && str[i+j]==delimiter[j])
            j++;
        if (j==delleng)//found delimiter
        {
            arr.push_back(  str.substr(k, i-k) );
            i+=delleng;
            k=i;
        }
        else
        {
            i++;
        }
    }
    arr.push_back(  str.substr(k, i-k) );
    return arr;
}

//find lcm
void findlcm() {
    int lcm=2;
    int i;
    
    //find 1st element with non-ONE denominator
    for(i=2; i< nullspace.size(); i++) {
        if(nullspace[i].getd() != 1) {
            int a = nullspace[i].getd();
            int b = nullspace[i+1].getd();
            lcm = a*b/gcd(a,b);
        }
        }
    
    //for remaining elements
    for(int j=i; j< nullspace.size(); j++) {
        //find lcm of lcm and nullspace element
            if(nullspace[j].getd() != 1 || (lcm%nullspace[j].getd()==0) ) { //if den is 1 or if lcm already divides den, no need to find lcm
                int t = lcm;
                lcm = t*nullspace[j].getd()/(gcd(t, nullspace[j].getd()));
                }
    }     
    //pc.printf("lcm: %d\r\n", lcm);
    
    //now we have lcm, we need to multiply each nullspace numerator by lcm, to create a new rational.
    //and fill in the new numbers as integers into q
    for(int i=0;i<nullspace.size();i++) {
        Rationals temp = Rationals(nullspace[i].getn()*lcm, nullspace[i].getd());
        q[i] =  temp.getn();
        //pc.printf("%d ",q[i]);
    }
    //pc.printf("\r\n");
    
}

void find_nullspace( )
{
    int x=0,y=0;    
    vector< vector<int> > solve;
    solve.resize(matrix.size(), vector <int> (4));
    
    for(int i=0; i<matrix.size(); i++) {
        for(int j=0; j<matrix[0].size(); j++) {
            // if non zero, add quantity and j value?
            if(matrix[i][j].getn()!=0) {
                //solve - Q1 x1 Q2 x2 => q1x1=q2x2 is the equation
                solve[x][y]= matrix[i][j].getn();
                solve[x][y+1]=j;      
                y=y+2;
                }
        }
        y=0;
        x++;
      }
      
    /* debug info for solve
    for(int i=0; i<solve.size();i++){
        for(int j=0;j<solve[0].size();j++)
            pc.printf("%d ", solve[i][j]);
        pc.printf("\r\n");
        }*/
        
    //start with something set
    int c = solve[0][1];
    nullspace[c]= Rationals(1,1);
    
    for(int i=0; i< solve.size();i++) {
        // start with 1st line -> nullspace[solve[][]]
        //for(int j=0; j<solve[0].size();j++) {
            int rhs = solve[i][3];
            int lhs = solve[i][1];
            //check for duplication with incorrect cfts
            for(int j=0; j< solve.size(); j++) {
                if(solve[j][3] == rhs && solve[j][1] == lhs) {                   
                    
                    //if k.x1 = s.x2 and K.x1 = S.x2, k/s = K/S is okay, and k/s != K/S implies contradiction
                    // ex. x1 = x2, and x1 = 2x2 is a contradiction, and has no solution
                    if(solve[i][0]/solve[i][2] != solve[j][0]/solve[j][2]) {                        
                        NO_SCHEDULE = true;
                        break; }
                    }
            }
            
            //check if there's an inherent contradiction
            //if value of rhs already set, check if new value = old value, if not, no schedule?            
            if(nullspace[rhs].getn() != -1) {
                if(nullspace[rhs].getn()/nullspace[rhs].getd() != (-solve[i][0]*nullspace[lhs].getn()/ solve[i][2]) ) {
                    //pc.printf("%d /%d = -%d * %d/ %d\r\n", nullspace[rhs].getn(), nullspace[rhs].getd(), solve[i][0],nullspace[lhs].getn(), nullspace[lhs].getd());
                    NO_SCHEDULE = true;
                    break;
                    }
            }                
            nullspace[rhs] = Rationals(-solve[i][0]*nullspace[lhs].getn(), solve[i][2]); //change the nullspace[lhs] here.        
    }
    
    //sucessfully found nullspace or returned with conflcits
    if(NO_SCHEDULE) {
        pc.printf("NO SCHEDULE\r\n");
        exit(0);
        }        
    //successfully found nullspace
    
    //simulating nullspace lcm --testing -- also tests no schedule later
    //nullspace[2] = Rationals(1,2); 
    
    for(int i=0; i<nullspace.size();i++) {
        // if some value has den > 1, we need to find lcm of all denominators.
        // and in findlcm, we should multiply numerators by corresponding value
        q[i]=nullspace[i].getn();
        if(nullspace[i].getd() != 1) {
            findlcm();
            break;
            }
     }
    
    // b[n+1] = b[n] + tau*v[n] for each node n, q[n] times
    // start with 0, b[0] is current buffer state
    // find new buffer state (may need a new buffer variable) based on tau*v[0], where v[0] is a 13x1 col vector with 1 in the node 0
    
    /* Debugging Use Only
    int total = 0;
    for(int i=0;i<q.size();i++)
    {
        total+=q[i];
    }
    pc.printf("total: %d\r\n",total);*/
    
    // rollback buffer if negative
    bool rollback = false;
    // store # of nodes completed firing -qz
    // store # of rollbacks to check when no node can be scheduled - rb
    int qz =0, rb =0;    
    do{
        for(int i = 0; i < q.size(); i++) {
            if(q[i]!=0) {
                //  v[i] = 1; //13x1 vector with 1 in node i'th place
                //  vector <int> product (tau.size());// = multiply(tau,v); //16x13 . 13x1 = 16x1                
                for(int j = 0; j < buffer.size(); j++) {                    
                    buffer_next[j] = buffer[j]+tau[j][i];
                    //pc.printf("%d ",buffer_next[j]);
                    if(buffer_next[j] < 0) {
                        rollback = true;
                        break;
                        }
                    }
                if(!rollback) {     //if node runnable, then set buffer next
                    q[i]--;
                    if(q[i] == 0) {
                        qz++;
                        schedule.push_back(i);
                     }
                    buffer = buffer_next;
                    //pc.printf("Node fired %d\r\n",i);
                    }                 
                else rb++;
              }
              if(rollback) {                 
                rollback = false;                
                }              
            }  
            //pc.printf("rb: %d qz: %d\r\n",rb, qz);
            if(qz == q.size()) break;
            if(rb+qz > q.size()) { 
                  pc.printf("NO SCHEDULE\r\n");
                  exit(1);
            }                      
    }while(qz!=q.size());   //do, while some node has yet to run
    
    //if we got here, it means we have found a schedule
    pc.printf("SCHEDULE: Lists nodes in order of completion\r\n");    
    for(int i=0; i<schedule.size();i++) {         
        pc.printf("%d ",schedule[i]);
    }
    pc.printf("\r\n");
    
}