/**
    Header File
    Provides functions for processing input samples
**/

// perform specific actions based on what kind of node it is
void execute_node (int ci, int sample)
{
    int j,e, ie1,ie2,s1,s2; //o[K];
       switch(node_types[ci])
           {
            case 'I': // I oe1 [oe2 ...]
                for (e=0; e < tau.size(); e++) {
                    //if edge is output edge, then write samples to it
                    if( tau[e][ci] == 1) {                            
                            //get stuff from input ring and put into oe e
                            fifos[e].push(inBuffer[sample]);
                            }
                }           
            break;
            case 'O': // O ie
            /* # of Input Samples =  # of Output samples for BALANCED graph (since graph is schedulable if balanced)*/
                //pc.printf("%d %d", edge_array[0]+1, ci+1);
                //take from ie
                for (e=0; e < tau.size(); e++) {
                    //if edge is output edge, then write samples to it
                    if( tau[e][ci] == -1) {                              
                            //get stuff from edge ie and put into output ring
                            outBuffer[sample]=fifos[e].front();
                            fifos[e].pop();
                            e=tau.size(); //can only be one input
                     }
                }
                break;
            case 'A': //A ie1 ie2 oe1 [oe2 ..]           
                //check for the two input edges first?           
                ie1=-1;ie2=-1;
                for(e=0;e<tau.size();e++) 
                    {
                        if(tau[e][ci] == -1)
                        {
                            if(ie1 < 0)
                                ie1 = e;
                            else if(ie2 < 0) {
                                ie2 = e;
                                e=tau.size();
                                } //found both edges, exit loop
                        }                            
                    }
                 
                //check that ie1 and ie2 are not <0   
                                 
                //input edges found -- do A operation
                if( fifos[ie1].empty() || fifos[ie2].empty() ) {
                        pc.printf("Error");
                    }
                                            
                s1 = fifos[ie1].front();
                fifos[ie1].pop();                                   
                s2 = fifos[ie2].front();
                fifos[ie2].pop();                   
                for (e=0; e < tau.size(); e++) {
                    //if edge is output edge, then write added samples to it
                    if( tau[e][ci] == 1) {                        
                                fifos[e].push(s1+s2);
                            }                     
                }
                break;
            case 'S': // S ie1 ie2 oe1 [oe2...]
                ie1=-1;ie2=-1;
                for(e=0;e<tau.size();e++) 
                    {
                        if(tau[e][ci] == -1)
                        {
                            if(ie1 < 0)
                                ie1 = e;
                            else if(ie2 < 0) {
                                ie2 = e;
                                e=tau.size();
                                } //found both edges, exit loop
                        }                            
                    }
                if( fifos[ie1].empty() || fifos[ie2].empty() ) {
                        pc.printf("Error");
                        exit(1);
                    }
                                            
                s1 = fifos[ie1].front();
                fifos[ie1].pop();                                   
                s2 = fifos[ie2].front();
                fifos[ie2].pop();
                for (e=0; e < tau.size(); e++) {
                    //if edge is output edge, then write added samples to it
                    if( tau[e][ci] == 1) {                        
                                fifos[e].push(s1-s2);
                            }                     
                }
                break;                
            case 'M': // M c d ie oe1 [oe2..]
                //find input edge
                for(e=0;e<tau.size();e++) 
                {
                    if(tau[e][ci] == -1)
                    {
                         break;
                    }
                }//found input edge, stored in e                
                
                if(fifos[e].empty()) {
                    pc.printf("Error %d!",ci);
                    exit(1);
                }
                s1 = fifos[e].front()*CD[iterM]/CD[iterM+1];
                iterM+=2;
                fifos[e].pop();
                                
                for(e=0;e<tau.size();e++)
                {
                    if(tau[e][ci] == 1) 
                    {
                          fifos[e].push(s1);                     
                    }
                }                
                break;
            case 'D': // D n ie oe1 [oe2...]
                // takes n samples                
                for(e=0;e<tau.size();e++) 
                {
                    if(tau[e][ci] < 0) //since input edge will take n samples
                    {
                         break;
                    }
                }//found input edge, stored in e
                
                if(fifos[e].empty()|| fifos[e].size()>NsamplesD[iterD]) {
                    pc.printf("Error %d! edge:%d, size:%d",ci, e, fifos[e].size());
                    exit(1);
                }
                
                for(j=0;j<NsamplesD[iterD];j++){
                    if(j == 0) 
                        s1 = fifos[e].front();
                    fifos[e].pop();//discard remaining samples                    
                }
                for(e=0;e<tau.size();e++)
                {
                    if(tau[e][ci] == 1) 
                    {
                          fifos[e].push(s1);                     
                    }
                }
                iterD++;
                break;               
            case 'U':
                for(e=0;e<tau.size();e++) 
                {
                    if(tau[e][ci] == -1)
                    {
                         break;
                    }
                }//found input edge, stored in e
                
                if(fifos[e].empty()) {
                    pc.printf("Error %d!",ci);
                    exit(1);
                }                
                s1 = fifos[e].front();
                fifos[e].pop();
                for(e=0;e<tau.size();e++)
                {
                    if(tau[e][ci] > 0) //since output edge will take n samples
                    {
                        //make N copies of S1
                        for(j=0;j<NsamplesU[iterU];j++)
                        {
                          fifos[e].push(s1);                     
                        }
                    }
                }                
                iterU++;
                break;
            case 'C':   
                //write K onto oe
                for(e=0;e<tau.size();e++)
                {
                    if(tau[e][ci] == 1) 
                    {
                          fifos[e].push(Kvalue[iterC]);                     
                    }
                }
                iterC++;
                break;
            case 'F': //F ie oe1 oe2 [oe3 ...]
                for(e=0;e<tau.size();e++) 
                {
                    if(tau[e][ci] == -1)
                    {
                         break;
                    }
                }//found input edge, stored in e
                if(fifos[e].empty()) {
                    pc.printf("Error %d %d!",ci,e);
                    exit(1);
                }                
                s1 = fifos[e].front();
                fifos[e].pop();
                
                //write to output edges
                for(e=0;e<tau.size();e++) 
                    {
                        if(tau[e][ci] == 1)
                        {
                            fifos[e].push(s1);
                        }                            
                    }
                break;
            /* SHOULD NOT APPEAR IN SCHEDULE
            case 'E': */
            default: //not a known node - oh no!
                pc.printf("Error: Unknown node, %d\r\n",ci);                
                exit(1);
           }
}

void process_input()
{
    int checksum = 0; // int is 4 bytes
    // read from inBuffer, apply schedule        
    // and have output from O node be written to a file
    for(int i=0; i<X;i++) //apply to input X times
    {           
        for(int j=0; j<K; j++) {
        iterM=0;iterD=0;iterU=0;iterC=0;
         // for each node in schedule period
           // pc.printf("in: %d: %d\r\n",j, inBuffer[j]);
            for(int it=0; it<schedule.size(); it++)
                execute_node(schedule[it],j);   //what node, what sample
           // pc.printf("out: %d: %d\r\n",j, outBuffer[j]);
        }                
    }
    
    for(int j=0;j<K;j++)
    {
        checksum ^= outBuffer[j];
    }    
    pin23 = 0;    
    //pc.printf("%d 0x%x\r\n",K,checksum);
    FILE * fpointer;
    fpointer = fopen("/local/output.txt","w");
    // write to output file
    fprintf(fpointer,"%d\r\n",K);
    fprintf(fpointer,"0x%x\r\n",checksum);
    for(int j=0;j<K;j++)
    {
        fprintf(fpointer,"%d\r\n",outBuffer[j]);
    }
    fclose(fpointer);
    pc.printf("DONE: count: %d checksum: 0x%x execution time(us):%d\r\n",X*K, checksum, t.read_us());    
}
