/* mbed GetTickCount Library
  * Copyright (c) 2010 Michael Wei
  */ 
  
//shouldn't have to include, but fixes weird problems with defines
#include "LPC1768/LPC17xx.h"

#ifndef MBED_TICKCOUNT_H 
#define MBED_TICKCOUNT_H 
extern volatile unsigned int TickCount;

inline void GetTickCount_Start(void) {
    //CMSIS SYSTICK Config
    SysTick_Config(SystemCoreClock / 100);               /* Generate interrupt every 10 ms */
}

inline void GetTickCount_Stop(void) {
    SysTick->CTRL = (1 << SYSTICK_CLKSOURCE) | (0<<SYSTICK_ENABLE) | (0<<SYSTICK_TICKINT);    /* Disable SysTick IRQ and SysTick Timer */
}

inline void GetTickCount_Reset(void) {
     SysTick->CTRL = (1 << SYSTICK_CLKSOURCE) | (0<<SYSTICK_ENABLE) | (0<<SYSTICK_TICKINT);    /* Disable SysTick IRQ and SysTick Timer */
     TickCount = 0;
     SysTick->CTRL = (1 << SYSTICK_CLKSOURCE) | (1<<SYSTICK_ENABLE) | (1<<SYSTICK_TICKINT);    /* Enable SysTick IRQ and SysTick Timer */
}

inline unsigned int GetTickCount(void)
{
    return TickCount;
}
#endif