#ifndef _RING_BUFFER_H
#define _RING_BUFFER_H

#include "mbed.h"

class RingBuffer{
private:

  /*buf is the maximum size of the ring buffer; start is the beginning of first valid element, end is the next available position
    to write*/
  int bufSize, start, end;
public:
  /*buf is the pointer to actual buffer start, bufEnd is the actual end of the buffer,
    end is the current available position to insert (no element is at end yet), start is the first full position*/
  int *buf;
  /*cur is used in next() method, denoting the current position in a sequential read, count is the number of elements*/
  int cur,count;

  RingBuffer(int *data=NULL, int bs=0):bufSize(bs),start(0),end(0),buf(data),cur(0),count(0){}
  ~RingBuffer(){buf=NULL;}
  void insert(int sample);
  int next();
  int getCount()const{return count;}
  void dump(FILE *fp)const;
};

#endif