#include "RingBuffer.h"

void RingBuffer::insert(int sample){
  if((end+1)%bufSize==start){
    start=(start+1)%bufSize;
    cur=start;
    count--;
  }
  buf[end]=sample;
  end=(end+1)%bufSize;
  count++;
}

int RingBuffer::next(){
  int ret=buf[cur];
  cur=(cur+1)%bufSize;
  if ((cur >= end) && (count < bufSize)) cur = start;
  return ret;
}

void RingBuffer::dump(FILE *fp)const{
  if(!fp){
    int i=start;
    while(i!=end){
      printf("%d\r\n", buf[i]);
      i=(i+1)%bufSize;
    }
  }else{
    int i=start;
    while(i!=end){
      fprintf(fp, "%d\r\n", buf[i]);
      i=(i+1)%bufSize;
    }
  }
}