#include "mbed.h"
#include "math.h"
#include "rtos.h"
#include "Mem.h"
#include "Parser.h"
#include "AvailableMemory.h"

#define SAMPLES 1000
#define PRINT0(arg0) stdio_mutex.lock();while(!pc.writeable());pc.printf(arg0);stdio_mutex.unlock()
#define PRINT1(arg0,arg1) stdio_mutex.lock();while(!pc.writeable());pc.printf(arg0,arg1);stdio_mutex.unlock()
#define PRINT2(arg0,arg1,arg2) stdio_mutex.lock();while(!pc.writeable());pc.printf(arg0,arg1,arg2);stdio_mutex.unlock()
#define PRINT3(arg0,arg1,arg2,arg3) stdio_mutex.lock();while(!pc.writeable());pc.printf(arg0,arg1,arg2,arg3);stdio_mutex.unlock()
#define PRINT4(arg0,arg1,arg2,arg3,arg4) stdio_mutex.lock();while(!pc.writeable());pc.printf(arg0,arg1,arg2,arg3,arg4);stdio_mutex.unlock()

using namespace segundo::Utilities;

Serial pc(USBTX, USBRX);
LPC_TIM_TypeDef abc;
int cntr2 = 0;
Mutex stdio_mutex; 

//const int SamplingRate = 100;//sampling rate

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);
LocalFileSystem local("local");
short hp = 0;    
 //thread 1: display & filter, thread 2: process commands
void control_thread(void const *args) {
    PRINT0("Swap thread starts...\r\n");
    
    while(1)
    {
        int temp;
        scanf("%d",&temp);
        if (!temp)
        {
            hp = 0;
            PRINT0("Low-pass filter activated!\n\r");
        }
        else if (temp == 1)
        {
            hp = 1;
            PRINT0("High-pass filter activated!\n\r");
        }
        else 
        {
            
        }
    }
}
 
int main() {
    
    Thread controlThread(control_thread);
        
    RingBuffer *input=NULL, *output=NULL;
    input=new RingBuffer(inBuffer, 4096);
    output=new RingBuffer(outBuffer, 4096);
    SDFG *lpiir=new SDFG("/local/lpconf.txt",input,output);
    if (!lpiir) error("ERROR: could not allocate memory for LP IIR filter.\r\n"); else {PRINT0("LP IIR filter instance created...\n\r");}
    SDFG *hpiir=new SDFG("/local/hpconf.txt",input,output);
    if (!hpiir) error("ERROR: could not allocate memory for HP IIR filter.\r\n"); else {PRINT0("HP IIR filter instance created...\n\r");}

    Parser::parseInput("/local/input.txt",input);   
   
//    Thread monitorThread(monitor_thread, output);
    PRINT0("Starting filtering...\n\r");
    
    int pw;
    //int cntr=0;
    
    int checksum = 0;
    while (true) {
       if (hp)
           hpiir->execute(1);  
       else 
           lpiir->execute(1);
       pw = output->next();  
       if (cntr2<SAMPLES) 
       { 
           checksum ^= pw;
           if (++cntr2 == SAMPLES)
           {
               PRINT1("Writing the checksum: 0x%X", checksum);
               FILE *fp=fopen("/local/output.txt", "w");
               fprintf(fp, "0x%X\r\n", checksum);
               fclose(fp);  
           }
       }
       
       led1 = (float)input->buf[input->cur]/1000;
       led2 = (float)pw/1000;       
       //PRINT1("LED1 = %d\r\n", input->cur);
       //PRINT1("LED2 = %d\r\n", output->cur);
       wait(0.02);
    }
    
}

