#ifndef _RATIONALNUM_H
#define _RATIONALNUM_H

#include "mbed.h"

int gcd(int x, int y);
int lcm(int x, int y);

class RationalNum{
  friend RationalNum operator + (RationalNum lhs, RationalNum rhs);
  friend RationalNum operator - (RationalNum lhs, RationalNum rhs);
  friend RationalNum operator * (RationalNum lhs, RationalNum rhs);
  friend RationalNum operator / (RationalNum lhs, RationalNum rhs);
  friend bool operator == (RationalNum lhs, RationalNum rhs);
  friend bool operator != (RationalNum lhs, RationalNum rhs);
  friend bool operator >= (RationalNum lhs, RationalNum rhs);
  friend bool operator > (RationalNum lhs, RationalNum rhs);
  friend bool operator <= (RationalNum lhs, RationalNum rhs);
  friend bool operator < (RationalNum lhs, RationalNum rhs);
private:
  int numerator;
  /*non-zero denominator*/
  int denominator;
public:
  RationalNum():numerator(0),denominator(1){}
  RationalNum(int n, int d):numerator(n),denominator(d){normalize();}
  RationalNum(int k):numerator(k),denominator(1){}
  RationalNum(const RationalNum &orig):numerator(orig.numerator),denominator(orig.denominator){normalize();}
  RationalNum& operator = (const RationalNum &rhs){numerator=rhs.numerator;denominator=rhs.denominator;return *this;}
  void print()const{printf("%d\\/%d", numerator, denominator);}
  int getNumerator()const{return numerator;}
  int getDenominator()const{return denominator;}
  void normalize();
};

#endif