#include "Parser.h"

void Parser::parseSDFG(char *path, SDFG *sdfg){
//  printf("Parsing SDF config... ", path); // Drive should be marked as removed
  FILE *fp=fopen(path, "r");
  if(!fp) {
    error("ERROR: no file located at \"%s\"\r\n",path);
    exit(1);
  }
  else
  {
//      printf("File opened!\n\r");
  }
  int n1=-1, n2=-1;
  char line[1024], delim[]=" ", *cur=NULL, symbol;
  for(int i=0; i<1024; i++)line[i]=0;
  int nodeId=0;
  while(fgets(line, 1024, fp)!=NULL){
    int temp, params[256], count=0;
    cur=strtok(line, delim);
    if(n1<0 && n2<0){
      n1=atoi(cur);
      cur=strtok(NULL,delim);
      n2=atoi(cur);
      sdfg->setNumOfNodes(n1);
      sdfg->setNumOfFIFOs(n2);
    }else if(strlen(cur)!=1){
      error("BAD SDFG FORMAT\r\n");
      exit(1);
    }else{
        symbol = cur[0];
        for(int i=0; i<256; i++)params[i]=0;
        count=0;
        cur=strtok(NULL,delim);
        while(cur){
          temp=atoi(cur);
          params[count++]=temp;
          cur=strtok(NULL,delim);
        }
        switch (symbol){
          case 'I': sdfg->getINode(nodeId++, params, count);
                    break;
          case 'O': sdfg->getONode(nodeId++, params, count);
                    break;
          case 'A': sdfg->getANode(nodeId++, params, count);
                    break;
          case 'S': sdfg->getSNode(nodeId++, params, count);
                    break;
          case 'M': sdfg->getMNode(nodeId++, params, count);
                    break;
          case 'D': sdfg->getDNode(nodeId++, params, count);
                    break;
          case 'U': sdfg->getUNode(nodeId++, params, count);
                    break;
          case 'C': sdfg->getCNode(nodeId++, params, count);
                    break;
          case 'F': sdfg->getFNode(nodeId++, params, count);
                    break;
          case 'E': sdfg->addDelay(params, count);
                    break;
          default: error("ERROR: BAD SDFG FORMAT\r\n");
                   exit(1);
                   break;
        }
    }
    for(int i=0; i<256; i++)params[i]=0;
    for(int i=0; i<1024; i++)line[i]=0;
  }
  //printf("Closing File...\r\n");
  fclose(fp);
  sdfg->buildTopologyMatrix();
}

void Parser::parseInput(char *path, RingBuffer *buf){
  //printf("Parsing input...\r\n");
  FILE *fp=fopen(path, "r");
  if(!fp){
    error("ERROR: no file located at \"%s\"\r\n",path);
    exit(1);
  }
  int count=0;
  int N=0;
  char line[20];
  for(int i=0; i<20; i++)line[i]=0;
  while(fgets(line, 20, fp)!=NULL){
    if(count==0){
      N=atoi(line);
      if(N<0){
        error("ERROR: BAD INPUT FORMAT\r\n");
        exit(1);
      }
    }else{
      buf->insert(atoi(line));
    }
    count++;
    for(int i=0; i<20; i++) line[i]=0;
  }
  fclose(fp);
  if(N!=count-1){
    error("ERROR: BAD INPUT FORMAT\r\n");
    exit(1);
  }
  else
  {
    //  printf("File closed.\n\r");
  }
}