#include <mbed.h>

// Boolean types
#define TRUE 1
#define FALSE 0


int main(void)
{
    unsigned char        ReadSample = 0xFF;
    // Indices to track where the playback and recording should take place in the
    // audio buffer.  The recording can occur one sample behind the current playback
    // index since it is no longer required.
    int                  Index = 0;
    // Reverse the direction the buffer is walked between each iteration to save memory
    int                  Direction = 1;
    // Have audio to playback
    int                  Playback = FALSE;
    // The amount of data to be recorded before starting reverse playback
    // NOTE: Probably want this to be configured at runtime via a knob, etc.
    int                  ChunkSize = 256;
    // Allocate a buffer to be used for the audio recording
    // NOTE: Just showing a 20k buffer in a static for this example
    static const size_t  BufferSize = 20 * 1024;
    static unsigned char Buffer[BufferSize];
    
    // Infinite loop of recording and reverse playback
    for (;;)
    {
        unsigned char PlaySample;

        // Read out the sample from the buffer to be played back
        if (Playback)
        {
            PlaySample = Buffer[Index];
            // NOTE: Just printing out samples in reverse
            printf("%d: %d\r\n", Index, PlaySample);
            wait(0.2f);
        }
        
        // Obtain current audio sample from the A/D converter.
        // NOTE: I am just faking these values in this sample with an incrementing value
        ReadSample++;
        
        // Record the sample into the buffer right where a space was freed up from the PlaySample read above
        Buffer[Index] = ReadSample;
        
        // Increment the buffer pointer
        Index += Direction;
        
        // Check to see if the chunk has been filled
        if (Index < 0)
        {
            // Now have a chunk to be played back
            Playback = TRUE;
            // Reverse the direction of playback and recording
            Direction *= -1;
            Index = 0;
        }
        else if (Index >= ChunkSize)
        {
            // Now have a chunk to be played back
            Playback = TRUE;
            // Reverse the direction of playback and recording
            Direction *= -1;
            Index = ChunkSize - 1;
        }
    }
}