#include "mbed.h"
 
/* ADC for the microphone/input, DAC for the speaker/output */
AnalogIn mic(p19);
AnalogOut speaker(p18);
 
#define NUM_SAMPLES   15000
unsigned short buffer[NUM_SAMPLES];
 
int main()
{
    int i;
    for (i = 0; ; ) // infinite loop
    {
        /* read mike */
        buffer[i] = mic.read_u16();
        /* Write to speaker */
        speaker.write_u16(buffer[i]);
        /* Increment index and wrap around */
        i = (i+1) % NUM_SAMPLES;
    }
}