// Hello World example for the USBMIDI library (circular buffer)

#include "mbed.h"
#include "USBAudio.h"
#include "CircBuffer.h"

Serial pc(USBTX, USBRX);

// frequency: 48 kHz
#define FREQ 32000

// 1 channel: mono
#define NB_CHA 1

// length computed: each ms, we receive 48 * 16bits ->48 * 2 bytes. as there is one channel, the length will be 48 * 2 * 1
#define LENGTH_AUDIO_PACKET 32 * 2 * 1

#define USR_POWERDOWN    (0x104)

int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}
 

// USBAudio
USBAudio USBaudio(FREQ, NB_CHA, 0x7186, 0x7507);

// speaker connected to the AnalogOut output. The audio stream received over USb will be sent to the speaker
AnalogOut speaker(p18);

AnalogIn mic(p19);

// ticker to send data to the speaker at the good frequency
Ticker tic;

// circular buffer where will be stored data to be sent to the speaker
CircBuffer<int16_t> cbuf(LENGTH_AUDIO_PACKET);

// previous value sent to the speaker
uint16_t p_val = 0;

// function executed each 1/FREQ s
void tic_handler() {
    int16_t val;
    float speaker_value;
    unsigned short PlaySample;


    if (cbuf.available() >= 1) {
        cbuf.dequeue(&val);
        speaker_value = (float)val;

        // speaker_value between 0 and 65535
        speaker_value +=  32768.0;

        // adjust according to current volume
        speaker_value *= USBaudio.getVolume();
    } else {
        speaker_value = p_val;
    }
    p_val = speaker_value;
    
    /* ADAMGR: Inserting my May 30th reversing code here!!! */
  {
    static const unsigned int   BufferSize = 20 * 640;
    static unsigned short Buffer[BufferSize];
    
    static int           Index = 0;
    static int           Direction = 1;
    static int           Playback = false;
    static int           ChunkSize = BufferSize;
 
    unsigned short       ReadSample;
 
    /* Default PlaySample to the current sample from USB buffer. */
    PlaySample =  speaker_value;

    
    
    /* Read out the sample from the buffer to be played back */
    if (Playback)
    {
        PlaySample = Buffer[Index];
    }
    
    /* Obtain current audio sample from the USB buffer. */
    ReadSample = (unsigned short)speaker_value;
    
    /* Record the sample into the buffer right where a space was freed up from the PlaySample read above */
    Buffer[Index] = ReadSample  += mic.read_u16();
    
     /* Increment the buffer pointer */
    Index += Direction;
    
    /* Check to see if the chunk has been filled */
    if (Index < 0)
    {
        /* Now have a chunk to be played back */
        Playback = true;
        /* Reverse the direction of playback and recording */
        Direction *= -1;//Direction;
        Index = 0;
    }
    else if (Index >= ChunkSize)
    
    

    {
       /* Now have a chunk to be played back */
        Playback = true;
        /* Reverse the direction of playback and recording */
        Direction *= -1;//Direction;
        Index = ChunkSize - 1;
    }
  }
  

    // send value to the speaker
    speaker.write_u16((uint16_t)PlaySample);
}

int main() {
    int16_t buf[LENGTH_AUDIO_PACKET/2];
    
    semihost_powerdown();

    // attach a function executed each 1/FREQ s
    tic.attach_us(tic_handler, 1000000.0/(float)FREQ);

    while (1) {
        // read an audio packet
        USBaudio.read((uint8_t *)buf);

        // put buffer in the circ buffer
        for(int i = 0; i < LENGTH_AUDIO_PACKET/2; i++) {
            cbuf.queue(buf[i]);
        }
    }
}
