#include <mbed.h>
 
// Boolean types
#define TRUE 1
#define FALSE 0

/* ADC for the microphone/input, DAC for the speaker/output */
AnalogIn mic(p19);
AnalogOut speaker(p18);
 
// Allocate a buffer to be used for the audio recording
static const size_t   BufferSize = 15 * 1024;
static unsigned short Buffer[BufferSize];
 
 
int main(void)
{
    unsigned short        ReadSample = 0xFFFF;
    // Indices to track where the playback and recording should take place in the
    // audio buffer.  The recording can occur one sample behind the current playback
    // index since it is no longer required.
    int                  Index = 0;
    // Reverse the direction the buffer is walked between each iteration to save memory
    int                  Direction = 1;
    // Have audio to playback
    int                  Playback = FALSE;
    // The amount of data to be recorded before starting reverse playback
    // NOTE: Probably want this to be configured at runtime via a knob, etc.
    int                  ChunkSize = BufferSize;
    
    // Infinite loop of recording and reverse playback
    for (;;)
    {
        unsigned short PlaySample;
 
        // Slow down the sampling rate so that it doesn't exceed 20kHz
        wait_us(50);
        
        // Read out the sample from the buffer to be played back
        if (Playback)
        {
            PlaySample = Buffer[Index];
            speaker.write_u16(PlaySample);
        }
        
        // Obtain current audio sample from the A/D converter.
        ReadSample = mic.read_u16();    
        
        // Record the sample into the buffer right where a space was freed up from the PlaySample read above
        Buffer[Index] = ReadSample;
        
         // Increment the buffer pointer
        Index += Direction;
        
        // Check to see if the chunk has been filled
        if (Index < 0)
        {
            // Now have a chunk to be played back
            Playback = TRUE;
            // Reverse the direction of playback and recording
            Direction *= -1;
            Index = 0;
        }
        else if (Index >= ChunkSize)
        {
            // Now have a chunk to be played back
            Playback = TRUE;
            // Reverse the direction of playback and recording
            Direction *= -1;
            Index = ChunkSize - 1;
        }
    }
}