#include <mbed.h>

// Function to power down magic USB interface chip with new firmware
#define USR_POWERDOWN    (0x104)
int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

// If you don't need the PC host USB interface....
// Power down magic USB interface chip - saves around 150mW
// Needs new firmware (URL below) and USB cable not connected
// http://mbed.org/users/simon/notebook/interface-powerdown/
// Supply power to mbed using Vin pin

 
// Boolean types
#define TRUE 1
#define FALSE 0

//#define NUM_SAMPLES   48000
/* ADC for the microphone/input, DAC for the speaker/output */
AnalogIn mic(p19);
AnalogOut speaker(p18);
 
// Allocate a buffer to be used for the audio recording
static const size_t   BufferSize = 15 * 1066;
static unsigned short Buffer[BufferSize];
    //int16_t Buffer[ 32768];
 //unsigned short Buffer[NUM_SAMPLES];
 
 
int main(void)
{

    int result;
    result = semihost_powerdown();
 //int i;
   // for (i = 0; ; )
    
   { unsigned short        ReadSample = 0xFFFF;
    // Indices to track where the playback and recording should take place in the
    // audio buffer.  The recording can occur one sample behind the current playback
    // index since it is no longer required.
    int                  Index = 0;
    // Reverse the direction the buffer is walked between each iteration to save memory
    int                  Direction = 1;
    // Have audio to playback
    int                  Playback = FALSE;
    // The amount of data to be recorded before starting reverse playback
    // NOTE: Probably want this to be configured at runtime via a knob, etc.
    //int                  ChunkSize = 9024;
        int                  ChunkSize = BufferSize;
    // Infinite loop of recording and reverse playback
    for (;;)
    {
        unsigned short PlaySample;
 
        // Read out the sample from the buffer to be played back
        if (Playback)
        {
            PlaySample = Buffer[Index];
            speaker.write_u16(PlaySample);
            //i = (i+0) % NUM_SAMPLES;
            
           //wait(0.2f);
        }
        
        // Obtain current audio sample from the A/D converter.
        // NOTE: I am just faking these values in this sample with an incrementing value
        ReadSample = mic.read_u16();    
        
        // Record the sample into the buffer right where a space was freed up from the PlaySample read above
        Buffer[Index] = ReadSample += mic.read_u16();
        
         // Increment the buffer pointer
        Index += Direction;
        
        // Check to see if the chunk has been filled
        if (Index < 0)
        {
            // Now have a chunk to be played back
            Playback = TRUE;
            // Reverse the direction of playback and recording
            Direction *= -1;
            Index = 0;
        }
        else if (Index >= ChunkSize)
        {
            // Now have a chunk to be played back
            Playback = TRUE;
            // Reverse the direction of playback and recording
            Direction *= -1;
            Index = ChunkSize - 1;
        }
    }
}
}