// Original: https://developer.mbed.org/users/ban4jp/code/CyaSSL-Twitter-OAuth4Tw/

#include <string.h>
#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "OAuth4Tw.h"
#include "lwip/dns.h"


Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
EthernetInterface eth;
NTPClient ntp;

OAuth4Tw oa4t("f3fcA4S61FcOz0VMLgia9ewn2",// Consumer key
              "Djaz2ooEf95b8yr3yE7DWS1XrYuwjBYZdz7QqnDKFTKNdMd8Ml", // Consumer secret
              "4044135739-da2aYe6fs6aCcpCKlqagVxM3rjDj5yPUaJaZ7O7", // Access token
              "uIrtt88FWWIz2yqpU9AkBeoLEHW5ls5ZdA9SoQvcGY47c");// Access token secret



#if defined(TARGET_LPC1768)
#define RESPONSE_BUFFER_SIZE 512
#elif defined(TARGET_K64F) || defined(TARGET_LPC4088)
#define RESPONSE_BUFFER_SIZE 4096
#else
#error not tested platform.
#endif

char response_buffer[RESPONSE_BUFFER_SIZE];
HTTPText response(response_buffer, sizeof(response_buffer));

// prototype
void updateTime();
void example_tweet1();
void example_tweet2();
void example_tweet3();
void example_getUserData();
void mm2(void);

Ticker mmTicker;
volatile int sum = 0;    

int main()
{
    pc.baud(115200);

    eth.init();
    // eth.init("172.20.29.40","255.255.255.0","172.20.29.1");
    // printf("Initialized, MAC: %s\n", eth.getMACAddress());

    // ip_addr_t primaryDnsServer;
    // ip4_addr_set_u32(&primaryDnsServer, ipaddr_addr("202.18.66.8")); 
    // dns_setserver(0, &primaryDnsServer);

    int ret;
    while ((ret = eth.connect()) != 0) {
        printf("Error eth.connect() - ret = %d\n", ret);
    }

    printf("Connected, IP: %s, MASK: %s, GW: %s\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());

    // requires accurate time, for OAuth Authorization.
    updateTime();


//    example_getUserData();
//        printf("\n");
    
    myled = 0;
    time_t ctTime;
        struct tm* lTime;
        int hour;
        int countmin = 0;

    
/*tickerオブジェクトで0.1秒ごとにmm2関数を呼び出す*/
    mmTicker.attach(&mm2, 0.5);     

    while (1) {
        time(&ctTime);
        lTime = localtime(&ctTime);
        hour = lTime->tm_hour;
        countmin = 5;
        if (12<=hour&&hour<=13) {
         countmin=15;
         }
    

        // Wait 60*5 seconds for next time.
        for (int t=0; t<60*countmin; t++) {
            myled = !myled;
            wait_ms(1000);
            printf("%d\n", sum);            
            //time(&ctTime);
            //lTime = localtime(&ctTime);
            //hour = lTime->tm_hour;
            //if (12<=hour&&hour<=13) break;
        }
        example_tweet2();
    }
    // mmTicker.detach();
}


void updateTime()
{
    printf("Trying to update time...\n");

    time_t ctTime;
    NTPResult result;

    while (1) {
        result = ntp.setTime("ntp.nict.jp");

        if (result == NTP_OK) {
            time(&ctTime);
            printf("Time is set to (UTC): %s\n", ctime(&ctTime));
            break;
        }

        switch (result) {
            case NTP_CONN:      ///<Connection error
                printf("Connection error\n");
                break;
            case NTP_TIMEOUT:   ///<Connection timeout
                printf("Connection timeout\n");
                break;
            case NTP_PRTCL:     ///<Protocol error
                printf("Protocol error\n");
                break;
            case NTP_DNS:       ///<Could not resolve name
                printf("Could not resolve name\n");
                break;
            default:
                printf("Error result=%d\n", result);
                break;
        }

        wait(5);
    }
}



/*センサ安定時間*/
#define INIT 30.0
/*ノイズ検出用*/
#define NOISE 0.1
/*センサ再読み取り時間*/
#define DELAY 0.05

DigitalIn pA(p19);
DigitalIn pB(p20);
DigitalOut led2(LED2);

void mm2(void)
{
    int nA = pA;
    int nB = pB;
    static int prevA = 0;
    static int prevB = 0;
    
    int status = 0;
    static int prevUpStatus = 0;

    if (prevA == nA)
        status = nA;
    if (prevB == nB)
        status |= (nB << 1);
    if (prevUpStatus == 0x03) {
        if (status == 0x02)
            sum++;
        else if (status == 0x01)
            sum--;
    }
        
    prevA = nA;
    prevB = nB;

    if (status)
        prevUpStatus = status;
}


void mm(void) {
    int a = 0;
    int b = 0;
    int c = 0;
    int d = 0;    
    int plus = 0;
    int minus = 0;
    led2 = 0;

//    pc.printf("a=%d b=%d c=%d d=%d\n",a,b,c,d);
   
            if(pA){
                wait(NOISE);
                if(pA){ 
                    a ++;
//                    pc.printf("a=%d\n",a);
                    wait(DELAY);
                    if(pB){
                        wait(NOISE);
                        if(pB){
                            b ++;
//                            pc.printf("b=%d\n",b);
                            wait(DELAY);
                            plus ++;
//                            pc.printf("plus=%d\n",plus);
                            }
                        }
                }
                wait(DELAY);
            }
            
            if(pB){
                wait(NOISE);
                if(pB){ 
                    c ++;
//                    pc.printf("c=%d\n",c);
                    wait(DELAY);
                    if(pA){
                        wait(NOISE);
                        if(pA){
                            d ++;
//                            pc.printf("d=%d\n",d);
                            wait(DELAY);
                            minus ++;
//                            pc.printf("minus=%d\n",minus);

                            }
                        }
                    }
                wait(DELAY);
                }         
        sum = plus - minus ;
//        pc.printf("sum=%d\n",sum);
}    

void example_tweet1()
{
    const char url[] = "https://api.twitter.com/1.1/statuses/update.json?status=Hello Everybody! Now, the number of people in the co-op - %s";
    char url2[128];


    time_t ctTime;

    time(&ctTime);

    snprintf(url2, sizeof(url2), url, ctime(&ctTime));

    HTTPResult result = oa4t.post(url2, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}

void example_tweet2(void)
{
    const char url[] = "https://api.twitter.com/1.1/statuses/update.json";
    wait(INIT);
    std::vector<std::string> post;
    post.reserve(1);

    char status[128];

    time_t ctTime;
    time(&ctTime);
    
    snprintf(status, sizeof(status), "status=Hello Everybody! Now, the number of people in the co-op - %d %s",sum, ctime(&ctTime));
    post.push_back(status);

    HTTPResult result = oa4t.post(url, &post, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}
/*
void example_tweet3()
{
    const char url[] = "https://api.twitter.com/1.1/statuses/update.json";

    std::vector<std::string> post;
    post.reserve(3);

    struct tm tmptr;
    char tmstr[34];
    char status[128];
    char location_lat[24];
    char location_long[24];

    time_t ctTime;
    time(&ctTime);
    ctTime += 9 * 60 * 60;  // Timezone: JST(+9h)
    localtime_r(&ctTime, &tmptr);

    // Tweets in Japanese
    strftime(tmstr, sizeof(tmstr), "%Y年%m月%d日 %H時%M分%S秒", &tmptr);
    snprintf(status, sizeof(status), "status=ハロー・ワールド！ - %s", tmstr);
    post.push_back(status);

    // Option: add Location information
    snprintf(location_lat, sizeof(location_lat), "lat=%f", 35.359577);
    snprintf(location_long, sizeof(location_long), "long=%f", 138.731414);
    post.push_back(location_lat);
    post.push_back(location_long);

    HTTPResult result = oa4t.post(url, &post, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}
*/

void example_getUserData()
{
    const char url[] = "https://api.twitter.com/1.1/users/show.json"
                       "?screen_name=twitter";

    HTTPResult result = oa4t.get(url, &response);

    if (result == HTTP_OK) {
        printf("GET success.\n%s\n", response_buffer);
    } else {
        printf("GET error. (result = %d)\n", result);
    }
}
