#include "mbed.h"
#include "C027_PinNames.h"

#include "SPI_TFT_ILI9341.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "UbloxUSBGSMModem.h"

void ubxLogo(SPI_TFT_ILI9341* tft, int x0/*120*/, int y0/*160*/, int r)
{
    int i1=r/8, i1_5=r*3/16, i2=r*2/8, i3=r*3/8, 
        i4=r*4/8,  i5=r*5/8, i6=r*6/8, i7=r*7/8;
    // the ball
    tft->fillcircle(x0,    y0,        r, Red);
    // the dot
    tft->fillcircle(x0-i3, y0+i2,  i1_5, White);
    // the u
    tft->fillcircle(x0+i3, y0-i4,    i3, White);
    tft->fillcircle(x0+i3, y0-i4,    i1, Red);
    tft->fillrect(  x0-i1, y0-i3, x0+i3, y0-i1, White);
    tft->fillrect(  x0-i1, y0-i5, x0+i3, y0-i3, Red);
    tft->fillrect(  x0-i1, y0-i7, x0+i6, y0-i5, White);
}

void initC027(void)
{
    DigitalOut mdmEn(MDMEN);
    DigitalOut mdmPwrOn(MDMPWRON);
    DigitalOut mdmRst(MDMRST);
    DigitalOut gpsEn(GPSEN);
    DigitalOut gpsRst(GPSRST);
    
    gpsEn    = 1; // LDOEN: 1=on,0=off
    gpsRst   = 1; // RESET: 0=reset,1=operating
    mdmPwrOn = 1; // PWRON: 1=idle,0=action
    mdmEn    = 1; // LDOEN: 1=on,0=off
    mdmRst   = 0; // RESET: 0=reset,1=operating
    Thread::wait(100);  //        power on sequence is triggered by 50ms reset low and wait for supplies ready
    mdmRst   = 1; // RESET: 1=operating,0=reset
    Thread::wait(3000);//         modem will be ready after 3 seconds
}
int main() 
{
    DigitalOut cs(D4); // sd card cs
    DigitalOut bl(D7); // backlight
    cs = 1;
    bl = 1;

    SPI_TFT_ILI9341 TFT(D11, D12, D13, D5, D3/*dummy*/, D6, "TFT"); // mosi, miso, sclk, cs, reset
    TFT.background(White);    // set background to black
    TFT.foreground(Black);    // set chars to white
    TFT.cls();                // clear the screen
    ubxLogo(&TFT, 120, 160, 80);
    TFT.set_font((unsigned char*) Arial12x12);  // select the font
    TFT.set_orientation(3);
    TFT.locate(70,220);
    TFT.printf("u-blox C027-C20/U20/G35");

    initC027();
    UbloxUSBGSMModem modem;
    
//#define MY_PHONE_NUMBER "+41765858801"
#ifdef MY_PHONE_NUMBER
    printf("Sending the SMS to\r\n" MY_PHONE_NUMBER "\r\n");
    modem.sendSM(MY_PHONE_NUMBER, "Hello  from mbed:)");
#endif    
    while(true)
    {
        size_t count;
        if(!modem.getSMCount(&count) && (count > 0))
        {
            char num[17], msg[64];
            printf("%d SMS to read\n", count);
            if(!modem.getSM(num, msg, sizeof(msg)))
            {
                printf("%s : %s\r\n", num, msg);
                TFT.fillrect(0,0,320,35,White);
                TFT.locate(0,5);
                TFT.printf("Phone: %s\nSMS:%s", num, msg);
            }
        }
        Thread::wait(3000);
    }
}
