#include "mbed.h"
#include "C12832.h"
#include "pitchs.h"
#include "LM75B.h"

#define DO 262
#define RE 294
#define MI 330

PwmOut buzzer(D6);
DigitalIn center(D4);
DigitalIn up (A2);
DigitalIn down (A3);
C12832 lcd(D11, D13, D12, D7, D10);
LM75B sensor(D14, D15);

enum {MARIO,LUNE,SENSOR} etat = MARIO;
int menu_precedent=LUNE;
//attentes
void att_up()
{
    while(up==1) {
        wait(0.125);
    }
}

void att_down()
{
    while(down==1) {
        wait(0.125);
    }
}

void att_center()
{
    while(center==1) {
        wait(0.125);
    }
}

void Afficher_Menu(int Menu)
{
    if(menu_precedent == Menu) return;
    menu_precedent = Menu;
    lcd.cls();
    lcd.locate(0,8);
    //wait(0.050);
    switch(Menu) {
        case MARIO:
            lcd.printf("Mario theme");
            break;
        case LUNE:
            lcd.printf("au claire de la lune");
            break;

    }
}

void lune()
{
    int melody[] = {DO,DO,DO,RE,MI,RE,DO,MI,RE,RE,DO};
    int noteDurations[] = {4,4,4,4,3,3,4,4,4,4,3};

    for (int thisNote = 0; thisNote < 11; thisNote++) {
        int noteDuration = noteDurations[thisNote];
        buzzer.period(1.0/melody[thisNote]);
        buzzer=0.25;
        wait(1.0/noteDuration);
        int pauseBetweenNotes = noteDuration * 1.30;
        wait(1.0/pauseBetweenNotes);
        buzzer=0;
    }
}

void mario()
{
    int melody[] = {
        NOTE_E7, NOTE_E7, 0, NOTE_E7,
        0, NOTE_C7, NOTE_E7, 0,
        NOTE_G7, 0, 0,  0,
        NOTE_G6, 0, 0, 0,

        NOTE_C7, 0, 0, NOTE_G6,
        0, 0, NOTE_E6, 0,
        0, NOTE_A6, 0, NOTE_B6,
        0, NOTE_AS6, NOTE_A6, 0,

        NOTE_G6, NOTE_E7, NOTE_G7,
        NOTE_A7, 0, NOTE_F7, NOTE_G7,
        0, NOTE_E7, 0,NOTE_C7,
        NOTE_D7, NOTE_B6, 0, 0,

        NOTE_C7, 0, 0, NOTE_G6,
        0, 0, NOTE_E6, 0,
        0, NOTE_A6, 0, NOTE_B6,
        0, NOTE_AS6, NOTE_A6, 0,

        NOTE_G6, NOTE_E7, NOTE_G7,
        NOTE_A7, 0, NOTE_F7, NOTE_G7,
        0, NOTE_E7, 0,NOTE_C7,
        NOTE_D7, NOTE_B6, 0, 0
    };
    int noteDurations[] = {
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        9, 9, 9,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
        9, 9, 9,
        12, 12, 12, 12,
        12, 12, 12, 12,
        12, 12, 12, 12,
    };

    for (int thisNote = 0; thisNote < 52; thisNote++) {
        int noteDuration = noteDurations[thisNote];
        buzzer.period(1.0/melody[thisNote]);
        buzzer=0.25;
        wait(1.0/noteDuration);
        int pauseBetweenNotes = noteDuration * 1.30;
        wait(1.0/pauseBetweenNotes);
        buzzer=0;
    }
}
int main()
{
    while(1) {
        switch(etat) {
            case MARIO:
                Afficher_Menu(etat);
                if(center) {
                    att_center();
                    mario();
                }
                if(down) etat=LUNE;
                att_down();
                break;
            case LUNE:
                Afficher_Menu(etat);
                if(center) {
                    att_center();
                    lune();
                }
                if(up) {
                    etat=MARIO;
                    att_up();
                }
                if(down) {
                    etat=SENSOR;
                    att_down();
                }
                break;
            case SENSOR:
                lcd.cls();
                lcd.locate(0,8);
                lcd.printf("Temp = %.3f\n\r", (float)sensor);
                wait(0.5);
                if(up) {
                    etat=LUNE;
                    lcd.locate(0,8);
                    lcd.printf("au claire de la lune");
                    att_up();
                }
                break;
        }
    }
}