

#include "mbed.h"
#include "stdlib.h"
#include "stdio.h"
#include <string.h>

//文字列受信関数プロトタイプ宣言
int stringReceive(void);
//float cramp関数プロトタイプ宣言
float fCramp(float,float,float);
//serialハードウェアバッファクリア関数プロトタイプ宣言
void bufferClear (void);

DigitalOut myled(LED1);
PwmOut pwmLed(dp1);

//シリアル初期化
Serial sensSerial (dp16, dp15);
//I2C初期化
I2C i2c(dp5 , dp27 ); //sda scl
const int addr = 0x20 << 1; // I2C address

int main() {
    //setup
    sensSerial.baud(9600);//シリアル通信開く
                  //(switchmbed基板でUSB通信するときは低速に抑えること)
    float gain = 100.0f;//ゲイン
    pwmLed.period(0.020);//PWM周期20ms
    pwmLed = 0.0f;
    myled = 0;

    //mainloop
    while(1){
        int val = 123;
        int receiveVal = 0;
        float pwmVal = 0.0f;
        receiveVal = stringReceive();
        
//I2C送信バッファ
        char cmd[10] = {'\0'};
        //int to asic2(sprintf関数)
        sprintf(cmd ,"%4d",/*1939*/receiveVal);//格納する配列アドレス , 書式文字列
        //null終端
        cmd[sizeof(cmd) - 1] = '\0'; /* NULL 終端する */
        //書き出し
        i2c.write(addr, cmd, 7);
        
        if(receiveVal >= 0){
            //I2C送信バッファ
        char cmd[10] = {'\0'};
        //int to asic2(sprintf関数)
        sprintf(cmd ,"val : %4d",/*1939*/receiveVal);//格納する配列アドレス , 書式文字列
        //null終端
        cmd[sizeof(cmd) - 1] = '\0'; /* NULL 終端する */
        //書き出し
        //i2c.write(addr, cmd, 5);
        wait(0.5);
            }
        
        }
 
}


//受信関数
//受信完了時0~4095
int stringReceive(){
    //各種定数
    //正常なデータ長,書き込み位置大きくなりすぎていないかチェック用
    const int dataLength = 7;//7個(6個のデータ+null終端)(添字は0~ 宣言時の大きさは1~)(添字の位置確認時は-1する)
    //startbitに使用する文字
    char startbitChar = '*';
    //stopbitに使用する文字
    char stopbitChar = '#';
    //各種変数
    //現在書き込むべきバッファの位置変数
    static int stringPosition = 0;
    //受信値一時格納変数
    char receiveChar = '\0';
    //受信データ格納バッファ文字列
    static char receiveDataString [dataLength] = {'\0'};//7個

    
    //データ送信要求
    sensSerial.putc('C');
    //ハードウェアバッファに到着した情報があるか
    //空ならリターン、あるなら受信値格納用変数にうつす
    if(!sensSerial.readable()){
        //空のとき
        return -1;
        }else{//あるとき
                receiveChar = sensSerial.getc();
            } 
    //バッファ書き込み位置変数が大きくなりすぎている
    //(ストップビットがくるはずがきてない)ときリターン
    if(stringPosition > (dataLength - 2)){
        stringPosition = 0;
        //ハードウェアバッファクリア
        bufferClear();
        return -2;
        }
        
    //到着していたデータがスタートビットだった場合
    if(receiveChar == startbitChar){
        
        //バッファクリア
        for (int i = 0;i < dataLength;i++){//配列の要素は0~ 大きさは1~
            receiveDataString[i] = '\0';
            }
        //書き込み位置変数クリア
        stringPosition = 0;
        //バッファへ書き込み
        receiveDataString[stringPosition] = receiveChar ;
        

        //書き込み位置進め
        stringPosition ++;
        //-1リターン
        return -3;
        }
    
    //到着していたデータが数字だった場合
    if(receiveChar=='0'||receiveChar=='1'||receiveChar=='2'||receiveChar=='3'||receiveChar=='4'||receiveChar=='5'||receiveChar=='6'||receiveChar=='7'||receiveChar=='8'||receiveChar=='9'){
        //バッファへ書き込み
        receiveDataString[stringPosition] = receiveChar ;
        
        //書き込み位置進め
        stringPosition++;
        //-1リターン
        return -4;
        }
    
    //到着していたデータがストップビットだった場合
    if(receiveChar == stopbitChar){
        //使う変数宣言
        //バッファ内容をコピーするための文字列
        char copyString [dataLength] = {'\0'};
        //スタート、ストップビットをトリムしたデータだけの文字列
        char trimString [dataLength] = {'\0'};
        //文字列→数値変換後の値を格納する変数
        int intVal = 0;
       
        //バッファへ書き込み
        receiveDataString[stringPosition] = receiveChar ;
        //null終端
        copyString[sizeof(copyString) - 1] = '\0'; /* NULL 終端する */
        receiveDataString[sizeof(receiveDataString) - 1] = '\0';//null終端
        
        
        //バッファの内容をうつす
        strlcpy(copyString,receiveDataString,sizeof(copyString));
        //バッファクリア
         for (int i = 0;i < dataLength;i++){//配列の要素は0~ 大きさは1~
            receiveDataString[i] = '\0';
            }
        //ハードウェアバッファクリア
        bufferClear();
        //書き込み位置クリア
        stringPosition = 0;
        
        //以下チェックとAtoI
        //先頭がスタートビットになってるか
        if(!(copyString[0] == startbitChar)){
            return -5;
            }
        //末尾がストップビットになっているか(配列の最後はnull)
        if(!(copyString[(dataLength - 2)] == stopbitChar)){
            return -6;
            }
        //データだけをトリミング
        //1個目から、後ろから2個目まで*xxxx#(\n)
        for(int Idx = 1; Idx < (dataLength - 2) ; Idx++){
            trimString[(Idx - 1) ] = copyString[Idx]; 
            }
        //null終端
        trimString[sizeof(trimString) - 1] = '\0'; /* NULL 終端する */
        //文字列→数値
        intVal = atoi(trimString);
        //数値リターン
        return intVal;
        
        }
        
        
    //以上にひっかからなかった異常時
        //バッファクリア
         for (int i = 0;i <= (dataLength - 1);i++){//配列の要素は0~ 大きさは1~
            receiveDataString[i] = '\0';
            }
        //ハードウェアバッファクリア
        bufferClear();
        //書き込み位置クリア
        stringPosition = 0;
        //-3リターン
        return -7;
    }
    
    
//cramp関数
float fCramp(float val , float min , float max){
    if(val < min){
        return min;
        }
    if(val > max){
        return max;
        }
        
        return val;   
    }
    
//serialハードウェアバッファクリア関数
void bufferClear(void){
    char temp = 0;
    while(sensSerial.readable()){
        temp = sensSerial.getc();
        }
        return;
    }