#include "mbed.h"

DigitalOut myled(LED1);
Serial uP(dp16, dp15);
AnalogIn ainCH1(dp4);
AnalogIn ainCH2(dp9);

//cramp関数arduinoのconstrain相当プロトタイプ宣言
int cramp(int , int , int);
//ADCサンプリング関数のプロトタイプ宣言
int adcSampling(int,int);
//バブルソート関数宣言
void bubbleSort(int *, int);
//ADCサンプリング数
const int numData = 5;
//抜重センサ出力値(オフセット補正用)
const int offsetValCH1 = 511;//(誤差なければ511)
const int offsetValCH2 = 510;//(誤差なければ511)

int main() {
    //setup
    //uP.baud(460800);//マイコン間通信時はコメント復帰
    uP.baud(9600);//USBテスト時はコメント復帰(linuxは高速通信できない）
    myled = 1;
    int val = 0;
    //mainloop
    while(1) {
        //ADC値取得(抜重センサ出力値)
        val = adcSampling(offsetValCH1,offsetValCH2);

        //シリアルバッファが読み込み可能になるまでwhileまわす可能ならifはいる
        if(uP.readable()>0){
            //もし自分宛てだったら返信する
            if(uP.getc() == 'C'){
                val = cramp(val , 0 , 1023);//0~1023に制限
                uP.printf("*%04d#",val);//返信 (*0#~*1023#)
                }
                
            }
    }
}

//ADCサンプリング平均値関数
//グローバルでnumDataが宣言してある必要あり(静的配列の宣言にnumData使うから)
int adcSampling(int offsetValCH1,int offsetValCH2){
    static int sampleArrayCH1 [numData] = {0};//時系列の生データ
    static int sampleArrayCH2 [numData] = {0};//時系列の生データ
    int sortArrayCH1 [numData] = {0};//ソート済みデータ
    int sortArrayCH2 [numData] = {0};//ソート済みデータ
    int centerVal = 511; //理想抜重時出力値
    
     //時系列配列を前から、一つ後ろのに書き換えて送る
        //CH1
        for(int i = 0;i <= numData - 1;i++){
            //もし最後最後尾を変更する回ならADC値入れる
            if(i == numData -1){
                sampleArrayCH1[i] = cramp (((ainCH1.read_u16()>>6)+(centerVal - offsetValCH1)),0,1023);//右へ6ビットシフト(16bitから10bitへ)
                break ;
                }
            //配列要素を前に一つ送る
            sampleArrayCH1[i] = sampleArrayCH1[i + 1];
            }
        //CH2
        for(int i = 0;i <= numData - 1;i++){
            //もし最後最後尾を変更する回ならADC値入れる
            if(i == numData -1){
                sampleArrayCH2[i] = cramp (((ainCH2.read_u16()>>6)+(centerVal - offsetValCH2)),0,1023);//右へ6ビットシフト(16bitから10bitへ)
                break ;
                }
            //配列要素を前に一つ送る
            sampleArrayCH2[i] = sampleArrayCH2[i + 1];
            }
            
    //バブルソート
        //時系列配列をソート用配列にコピー
            //CH1
        for(int i = 0; i < numData - 1; i++){
            sortArrayCH1[i] = sampleArrayCH1[i];
            }
           //CH2
        for(int i = 0; i < numData - 1; i++){
            sortArrayCH2[i] = sampleArrayCH2[i];
            }
        
        //バブルソート関数呼び出し
        bubbleSort(sortArrayCH1,numData);
        bubbleSort(sortArrayCH2,numData);
        
        //上と下一つづつを省いたサンプルを平均して,CH1とCH2の差分を返す
        int sumVal = 0;
        int aveValCH1 = 0;
        int aveValCH2 = 0;
        //CH1
        //合計
        for(int i = 1;i <= numData - 2;i++){
            sumVal = sumVal+sortArrayCH1[i];
            }
        //平均
        aveValCH1 = sumVal / (numData - 2);
        
        //CH2
        //合計
        sumVal = 0;
        for(int i = 1;i <= numData - 2;i++){
            sumVal = sumVal+sortArrayCH2[i];
            }
        //平均
        aveValCH2 = sumVal / (numData - 2);
        
        //値返す
        return (cramp((((aveValCH1-aveValCH2)/2)+511),0,1023)) ;
        
    }
   
   

//バブルソート(配列の名前(ポインタ),配列要素数)
void bubbleSort(int *sortArray,int numData){
           int temp = 0;
           //バブルソート本体
        for (int i = 0; i < numData - 1; i++) {
          for (int j = numData - 1; j > i; j--) {
                if (sortArray[j - 1] > sortArray[j]) {  //前の要素の方が大きかったら
                temp = sortArray[j];        // 交換する
                sortArray[j] = sortArray[j - 1];
                sortArray[j - 1]= temp;
                }
              }
          }
          
    }

 
//cramp関数
int cramp(int val , int min , int max){
    if(val < min){
        return min;
        }
    if(val > max){
        return max;
        }
        
        return val;   
    }
    
