#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "Speaker.h"
#include <vector>
#include <string>
#include "uLCD_4DGL.h"
#include "VS1002.h"
#include "mpr121.h"

FILE *wave_file;
string current_file;
string print_file;
string song;
string new_song;
Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
uLCD_4DGL uLCD(p28, p27, p29);
Ticker play_time;

vector<string> filenames; //filenames are stored in a vector string

int startStop = 0;

// OutKast, Kanye, Kenny Rogers, Sinatra, Odesza, DMX, 21 Pilots, Eminem
int array[] = { 0x000066, 0x000044, 0x000011, 0x000055, 0x000000, 0x000033, 0x000022, 0x000077};
vector<int> artwork(array, array + 8);
//below code goes in song playing function
//uLCD.media_init();
//uLCD.set_sector_address(0x0000, artwork[selected]);
//uLCD.display_image(0,0);

void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}

VS1002 mp3(p5, p6, p7, p8,"sd",p11, p12 ,p13, p14, p23, p22, p21, p15);  //Setup Audio decoder. Name is VS1002 even though VS1053 is used.
InterruptIn interrupt(p26); // Create the interrupt receiver object on pin 26
I2C i2c(p9, p10); // Setup the i2c bus on pins 9 and 10
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS); //Setup Mpr121

/* Global Variables to store Status*/
int new_song_number=0;  //Variable to store the Song Number
int old_song_number=0;
int volume_left = -15;     //Variable to store the Volume
int volume_right = -15;
int previous_volume_left;    //Variable to store the volume when muted
int previous_volume_right;
bool stop=true;
bool pause=false;
bool old_pause=false;       //Variable to store the status of Pause button
bool mute=false;
bool old_mute=false;        //Variable to store the status of mute button
int size;
int first;
int t=0;
int m=0;
int oldt=0;
int selected = 0;
int check = 0;   //Capacitative touch generates interrupt on both press and release. This variable tracks this and updates only on press.
int fade=0;
int old_fade=0;
int n=0;
int fade_percent;
string print_fade="Center";

void counter(void){
     if(!pause)
     {
        t++;
        if(t%60==0)
        {
            t=0;
            m++;
        }
     }
}

void fade_left(void)
{
    fade--;
    //pc.printf("fade left\n\rfade=%i\n\r",fade);
    if(fade<-5)
        fade=-5;
    fade_percent = abs(fade)*20;
    if(fade==0)
    {
        volume_left=volume_right;
        print_fade=("Center");
    }
    if(fade<0)
    {
        n=(volume_left+60)/5;
        volume_right=volume_left+fade*n;
        print_fade="Left";
      //  pc.printf("fade<0 volume_left=%i volume_right=%i n=%i\n\r",volume_left,volume_right,n);
    }
    if(fade>0)
    {
        n=(volume_right+60)/5;
        volume_left=volume_right-fade*n; 
        print_fade="Right";
      //  pc.printf("fade>0 volume_left=%i volume_right=%i n=%i\n\r",volume_left,volume_right,n);  
    }      
}

void fade_right(void)
{
    fade++;
    pc.printf("fade right\n\rfade=%i\n\r",fade);
    if(fade>5)
        fade=5;
    fade_percent = abs(fade)*20;
    if(fade==0)
    {
        volume_right=volume_left;
        print_fade=("Center");
    }
    if(fade<0)
    {
        n=(volume_left+60)/5;
        volume_right=volume_left+fade*n;
        print_fade="Left";
    //    pc.printf("fade<0 volume_left=%i volume_right=%i n=%i\n\r",volume_left,volume_right,n);
    }
    if(fade>0)
    {
        n=(volume_right+60)/5;
        volume_left=volume_right-fade*n;
        print_fade="Right";
   //     pc.printf("fade>0 volume_left=%i volume_right=%i n=%i\n\r",volume_left,volume_right,n);   
    }      
}

void volume_up(void)
{
    if(fade==0)
    {
        if(volume_right!=0)
            volume_right+=5;
        if(volume_left!=0)
            volume_left+=5;
    }
    if(fade<0)
    {
        if(volume_left!=0)
        {
            volume_left+=5;
            n=(volume_left+60)/5;
            volume_right=volume_left+fade*n;
        }   
    }
    if(fade>0)
    {
        if(volume_right!=0)
        {
            volume_right+=5;
            n=(volume_right+60)/5;
            volume_left=volume_right-fade*n; 
        }   
    }
}

void volume_down(void)
{
    if(fade==0)
    {
        if(volume_right!=-60)
            volume_right-=5;
        if(volume_left!=-60)
            volume_left-=5;
    }
    if(fade<0)
    {
        if(volume_left!=-60)
        {
            volume_left-=5;
            n=(volume_left+60)/5;
            volume_right=volume_left+fade*n;
            if(volume_right<-60)
                volume_right=-60;
        }   
    }
    if(fade>0)
    {
        if(volume_right!=-60)
        {
            volume_right-=5;
            n=(volume_right+60)/5;
            volume_left=volume_right-fade*n;
            if(volume_left<-60)
                volume_left=-60; 
        }   
    }
}

void fallInterrupt()
{
    int key_code=0;
    int i=0;
    int value;
    value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;

    i=0;
    if(check)
        check=0;
    else
        check=1;
    if(check) {
        for (i=0; i<12; i++) {
            if (((value>>i)&0x01)==1) key_code=i+1; //Convert value into decimal
        }

        switch(key_code) { // Different cases depending on key press
            case 0:
                break;  // Invalid entry . Valid 1-12
            case 1:
                if(stop)
                {
                    new_song_number+=1;  // Move selecter down
                    if(new_song_number==filenames.size())
                        new_song_number=0; // go back to beginning of vector
                }
                break;
            case 2:
            //play/stop button
                stop=!stop;
                first=0;
                break;
            case 3:
                fade_right();
                break;
            case 4:
                fade_left();
                break;
            case 5:
                if(stop)
                {
                    new_song_number-=1;  // move selecetor up
                    if(new_song_number==-1)
                        new_song_number=filenames.size()-1;  // Go to end of vector
                }
                break;
            case 6:
                break;
            case 7:
                new_song_number+=1;  // Otherwise Next song
                if(new_song_number==filenames.size()){
                    new_song_number=0;  // go back to beginning of vector
                }
                break;
            case 8:
                new_song_number-=1;  // Previous Song
                if(new_song_number==-1){
                   new_song_number=filenames.size()-1;  // Go to end of vector
                }
                break;
            case 9:
                old_pause=pause;
                pause=!pause; // Pause/Play button
                //stop=false;
                //first=0;
                break;
            case 10:
                volume_up();
                break;
            case 11:
                volume_down();
                break;
            case 12:
                old_mute=mute;
                mute=!mute;  //Mute/Unmute
                if(mute) {
                    previous_volume_left = volume_left; // Attenuation of -55 db is small enough to not hear anything
                    previous_volume_right = volume_right;
                    volume_left = -60;
                    volume_right = -60;
                } else {
                    volume_left=previous_volume_left;
                    volume_right = previous_volume_right;
                }
                break;
            default:
                uLCD.cls();
                uLCD.printf("error");  // exit on error
                exit(1);
        }
    }
}
int main ()
{
    read_file_names("/sd/myMusic"); // read file names into vector of strings

    
    /*============================================================
     * MP3 Initialising
     *==========================================================*/

    mp3._RST = 1;
    mp3.cs_high();                                  //chip disabled
    mp3.sci_initialise();                           //initialise MBED
    mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF));
    mp3.sci_write(0x03, 0x9800);
    mp3.sdi_initialise();


    /* Touch Pad setup */
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    play_time.attach(&counter, 1.0);

    while(1) {
        if(stop)
        {
            if(first==0)
            {
                uLCD.cls();
                int i=0;
                            // print filename strings from vector using an iterator
                for(vector<string>::iterator it=filenames.begin(); it < filenames.end(); it++) 
                {
                    print_file = (*it).substr(0, ((*it).size() - 4));
                    uLCD.locate(1,i);
                    uLCD.printf("%s\n",print_file.c_str());
                    i++;
                }
                size = filenames.size();
                first++;
            }
            uLCD.locate(0,new_song_number);
            uLCD.printf("*");
            if(old_song_number!=new_song_number)
            {
                uLCD.locate(0,old_song_number);
                uLCD.printf(" ");
                old_song_number=new_song_number;
            }
        }
        if(!stop)
        {
            current_file = filenames[new_song_number];
            print_file = current_file.substr(0, (current_file.size() - 4));
            string song = "/sd/myMusic/" + current_file;
            mp3.play_song(song, print_file, new_song_number);
        }
    }

}


