#pragma once
#include <algorithm>        // required for min() and max(), see http://www.cplusplus.com/reference/algorithm/
#include "mbed.h"
#include "Vector.h"

//#define MAX(x, y) (((x) > (y)) ? (x) : (y))
//#define MIN(x, y) (((x) < (y)) ? (x) : (y))

class Point
{ 
protected :
    int x1, y1;

public :
    Point();
    Point(int x, int y);
    int getX();
    int getY();
    void set(int x, int y);
};

class Rectangle;    // predefinition needed by Line class

class Line
{
protected :
    int x1, x2, y1, y2;

public :
    Line(int x1,int y1, int x2, int y2);
    Line(Point p1, Point p2);
    Point get1();
    Point get2();
    float getSizeFloat();
    int getSize();
    Rectangle getBoundingRectangle();
    int getDistance(Point pt);
};

class Rectangle
{
protected :
    int x1, x2, y1, y2;
 
public :
    Rectangle(int x,int y, int x2, int y2);
    Rectangle(Point pt1, Point pt2);
    bool collides(Point pt);
    bool collides(Rectangle r);

    void set(Rectangle rNew);
    
    Point get1();
    Point get2();
    Point get3();
    Point get4();
    Point getCenter();

    int getX1();
    int getX2();
    int getY1();
    int getY2();
    int getCenterX();
    int getCenterY();
    bool isHorizontal();
    void move(Vector v);
};

class Circle
{ 
protected :
    int x1, y1, r1;

public :
    Circle(int x,int y, int r);
    Point getCenter();
    int getRadius();
    int getX();
    int getY();
    void setX(int x);
    void setY(int y);
    void setXY(int x, int y);
    void move(int x, int y);
    void move(Vector v);
    Rectangle getBoundingRectangle();
    bool collides(Line l);
};

