#include "Physics.h"

Position::Position() : vPos(), pPrev(), pCur()
{   // constructor

}

Point Position::getPrev()
{
    return(pPrev);
}

Point Position::getCur()
{
    return(pCur);
}

int Position::getX()
{
    return(pCur.getX());
}
int Position::getY()
{
    return(pCur.getY());
}

void Position::set(float x, float y)
{
    pPrev=pCur;
    vPos.x=x;
    vPos.y=y;
    pCur.set(rint(vPos.x), rint(vPos.y));
}

void Position::set(int x, int y)
{
    set((float)x, (float)y);
}

void Position::set(Point ptNew)
{
    set(ptNew.getX(), ptNew.getY());
}

void Position::setX(int x)
{
    set((float)x, vPos.y);
}

void Position::setY(int y)
{
    set(vPos.x, (float)y);
}

void Position::move(float fDiffX, float fDiffY)
{
    pPrev=pCur;
    vPos.x+=fDiffX;
    vPos.y+=fDiffY;
    pCur.set(rint(vPos.x), rint(vPos.y));
}

void Position::move(int nDiffX, int nDiffY)
{
    move((float)nDiffX, (float)nDiffY);
}

void Position::move(Vector vDiff)
{
    move(vDiff.x, vDiff.y);
}

bool Position::hasChanged()
{
    //return(nPrevX!=nCurX || nPrevy!=nCury);
    return(pPrev.getX()!=pCur.getX() || pPrev.getY()!=pCur.getY());
}

Dimension::Dimension()
{
    nWidth=0;
    nHeight=0;
}